/**ABDB**/CREATE TABLE `#__workflows` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT '0',
  `published` tinyint(4) NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_extension` (`extension`),
  KEY `idx_default` (`default`),
  KEY `idx_created` (`created`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_modified` (`modified`),
  KEY `idx_modified_by` (`modified_by`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflows`  VALUES 
('1', '0', '1', 'COM_WORKFLOW_BASIC_WORKFLOW', '', 'com_content.article', '1', '1', '2021-09-16 08:15:17', '0', '2021-09-16 08:15:17', '0', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_transitions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `workflow_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_stage_id` int(11) NOT NULL,
  `to_stage_id` int(11) NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_from_stage_id` (`from_stage_id`),
  KEY `idx_to_stage_id` (`to_stage_id`),
  KEY `idx_workflow_id` (`workflow_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_transitions`  VALUES 
('1', '0', '1', '1', '1', 'UNPUBLISH', '', '-1', '1', '{\"publishing\":\"0\"}', NULL, NULL),
('2', '0', '2', '1', '1', 'PUBLISH', '', '-1', '1', '{\"publishing\":\"1\"}', NULL, NULL),
('3', '0', '3', '1', '1', 'TRASH', '', '-1', '1', '{\"publishing\":\"-2\"}', NULL, NULL),
('4', '0', '4', '1', '1', 'ARCHIVE', '', '-1', '1', '{\"publishing\":\"2\"}', NULL, NULL),
('5', '0', '5', '1', '1', 'FEATURE', '', '-1', '1', '{\"featuring\":\"1\"}', NULL, NULL),
('6', '0', '6', '1', '1', 'UNFEATURE', '', '-1', '1', '{\"featuring\":\"0\"}', NULL, NULL),
('7', '0', '7', '1', '1', 'PUBLISH_AND_FEATURE', '', '-1', '1', '{\"publishing\":\"1\",\"featuring\":\"1\"}', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_stages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `workflow_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_workflow_id` (`workflow_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_default` (`default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_stages`  VALUES 
('1', '0', '1', '1', '1', 'COM_WORKFLOW_BASIC_STAGE', '', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_associations` (
  `item_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Extension table id value',
  `stage_id` int(11) NOT NULL COMMENT 'Foreign Key to #__workflow_stages.id',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`item_id`,`extension`),
  KEY `idx_item_stage_extension` (`item_id`,`stage_id`,`extension`),
  KEY `idx_item_id` (`item_id`),
  KEY `idx_stage_id` (`stage_id`),
  KEY `idx_extension` (`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_associations`  VALUES 
('11', '1', 'com_content.article'),
('12', '1', 'com_content.article'),
('13', '1', 'com_content.article'),
('14', '1', 'com_content.article'),
('15', '1', 'com_content.article'),
('16', '1', 'com_content.article'),
('17', '1', 'com_content.article'),
('18', '1', 'com_content.article'),
('19', '1', 'com_content.article'),
('20', '1', 'com_content.article'),
('21', '1', 'com_content.article'),
('22', '1', 'com_content.article'),
('23', '1', 'com_content.article'),
('24', '1', 'com_content.article');
/**ABDB**/CREATE TABLE `#__webauthn_credentials` (
  `id` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential ID',
  `user_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'User handle',
  `label` varchar(190) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Human readable label',
  `credential` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential source data, JSON format',
  PRIMARY KEY (`id`(100)),
  KEY `user_id` (`user_id`(60))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__viewlevels`  VALUES 
('1', 'Public', '0', '[1]'),
('2', 'Registered', '2', '[6,2,8]'),
('3', 'Special', '3', '[6,3,8]'),
('5', 'Guest', '1', '[9]'),
('6', 'Super Users', '4', '[8]');
/**ABDB**/CREATE TABLE `#__users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT '0',
  `sendEmail` tinyint(4) DEFAULT '0',
  `registerDate` datetime NOT NULL,
  `lastvisitDate` datetime DEFAULT NULL,
  `activation` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastResetTime` datetime DEFAULT NULL,
  `resetCount` int(11) NOT NULL DEFAULT '0' COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'One time emergency passwords',
  `requireReset` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Require user to reset password on next login',
  `authProvider` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_name` (`name`(100)),
  KEY `idx_block` (`block`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=581 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__users`  VALUES 
('580', 'Super User', 'admin', 'sample@email.com', '$2y$10$XYMqPDBljH.kkF/sKgvf1ehJ8j8tGnej16wgrm/zcESPjgI3ayuzS', '0', '1', '2020-12-19 21:19:53', '2023-03-12 19:45:11', '0', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"timezone\":\"\",\"a11y_mono\":\"0\",\"a11y_contrast\":\"0\",\"a11y_highlight\":\"0\",\"a11y_font\":\"0\"}', NULL, '0', '', '', '0', '');
/**ABDB**/CREATE TABLE `#__usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Adjacency List Reference Id',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__usergroups`  VALUES 
('1', '0', '1', '18', 'Public'),
('2', '1', '8', '15', 'Registered'),
('3', '2', '9', '14', 'Author'),
('4', '3', '10', '13', 'Editor'),
('5', '4', '11', '12', 'Publisher'),
('6', '1', '4', '7', 'Manager'),
('7', '6', '5', '6', 'Administrator'),
('8', '1', '16', '17', 'Super Users'),
('9', '1', '2', '3', 'Guest');
/**ABDB**/CREATE TABLE `#__user_usergroup_map` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__users.id',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__user_usergroup_map`  VALUES 
('580', '8');
/**ABDB**/CREATE TABLE `#__user_profiles` (
  `user_id` int(11) NOT NULL,
  `profile_key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Simple user profile storage table';
/**ABDB**/INSERT INTO `#__user_profiles`  VALUES 
('580', 'joomlatoken.enabled', '1', '2'),
('580', 'joomlatoken.token', 'fVgj4oyq45X9vFMJytG5e5rOxKnwzwtciKlMR7t9qgo=', '1');
/**ABDB**/CREATE TABLE `#__user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `review_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__user_mfa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `method` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT '0',
  `options` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_on` datetime NOT NULL,
  `last_used` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Multi-factor Authentication settings';
/**ABDB**/CREATE TABLE `#__user_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `series` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uastring` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series` (`series`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT '0',
  `extension_id` int(11) DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `folder` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `client_id` tinyint(3) DEFAULT '0',
  `version` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detailsurl` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `infourl` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text COLLATE utf8mb4_unicode_ci,
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates';
/**ABDB**/INSERT INTO `#__updates`  VALUES 
('54', '2', '0', 'Afrikaans', '', 'pkg_af-ZA', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/af-ZA_details.xml', '', '', ''),
('55', '2', '0', 'Arabic Unitag', '', 'pkg_ar-AA', 'package', '', '0', '4.0.2.1', '', 'https://update.joomla.org/language/details4/ar-AA_details.xml', '', '', ''),
('56', '2', '0', 'Bulgarian', '', 'pkg_bg-BG', 'package', '', '0', '4.2.7.1', '', 'https://update.joomla.org/language/details4/bg-BG_details.xml', '', '', ''),
('57', '2', '0', 'Catalan', '', 'pkg_ca-ES', 'package', '', '0', '4.0.4.2', '', 'https://update.joomla.org/language/details4/ca-ES_details.xml', '', '', ''),
('58', '2', '0', 'Chinese, Simplified', '', 'pkg_zh-CN', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/zh-CN_details.xml', '', '', ''),
('59', '2', '0', 'Chinese, Traditional', '', 'pkg_zh-TW', 'package', '', '0', '4.2.3.1', '', 'https://update.joomla.org/language/details4/zh-TW_details.xml', '', '', ''),
('60', '2', '0', 'Czech', '', 'pkg_cs-CZ', 'package', '', '0', '4.2.0.1', '', 'https://update.joomla.org/language/details4/cs-CZ_details.xml', '', '', ''),
('61', '2', '0', 'Danish', '', 'pkg_da-DK', 'package', '', '0', '4.2.7.1', '', 'https://update.joomla.org/language/details4/da-DK_details.xml', '', '', ''),
('62', '2', '0', 'Dutch', '', 'pkg_nl-NL', 'package', '', '0', '4.2.7.1', '', 'https://update.joomla.org/language/details4/nl-NL_details.xml', '', '', ''),
('63', '2', '0', 'English, Australia', '', 'pkg_en-AU', 'package', '', '0', '4.2.8.2', '', 'https://update.joomla.org/language/details4/en-AU_details.xml', '', '', ''),
('64', '2', '0', 'English, Canada', '', 'pkg_en-CA', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/en-CA_details.xml', '', '', ''),
('65', '2', '0', 'English, New Zealand', '', 'pkg_en-NZ', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/en-NZ_details.xml', '', '', ''),
('66', '2', '0', 'English, USA', '', 'pkg_en-US', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/en-US_details.xml', '', '', ''),
('67', '2', '0', 'Estonian', '', 'pkg_et-EE', 'package', '', '0', '4.2.7.3', '', 'https://update.joomla.org/language/details4/et-EE_details.xml', '', '', ''),
('68', '2', '0', 'Finnish', '', 'pkg_fi-FI', 'package', '', '0', '4.1.1.2', '', 'https://update.joomla.org/language/details4/fi-FI_details.xml', '', '', ''),
('69', '2', '0', 'Flemish', '', 'pkg_nl-BE', 'package', '', '0', '4.2.6.1', '', 'https://update.joomla.org/language/details4/nl-BE_details.xml', '', '', ''),
('70', '2', '0', 'French', '', 'pkg_fr-FR', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/fr-FR_details.xml', '', '', ''),
('71', '2', '0', 'Georgian', '', 'pkg_ka-GE', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/ka-GE_details.xml', '', '', ''),
('72', '2', '0', 'German', '', 'pkg_de-DE', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/de-DE_details.xml', '', '', ''),
('73', '2', '0', 'German, Austria', '', 'pkg_de-AT', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/de-AT_details.xml', '', '', ''),
('74', '2', '0', 'German, Liechtenstein', '', 'pkg_de-LI', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/de-LI_details.xml', '', '', ''),
('75', '2', '0', 'German, Luxembourg', '', 'pkg_de-LU', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/de-LU_details.xml', '', '', ''),
('76', '2', '0', 'German, Switzerland', '', 'pkg_de-CH', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/de-CH_details.xml', '', '', ''),
('77', '2', '0', 'Greek', '', 'pkg_el-GR', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/el-GR_details.xml', '', '', ''),
('78', '2', '0', 'Hungarian', '', 'pkg_hu-HU', 'package', '', '0', '4.2.7.1', '', 'https://update.joomla.org/language/details4/hu-HU_details.xml', '', '', ''),
('79', '2', '0', 'Irish', '', 'pkg_ga-IE', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/ga-IE_details.xml', '', '', ''),
('80', '2', '0', 'Italian', '', 'pkg_it-IT', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/it-IT_details.xml', '', '', ''),
('81', '2', '0', 'Japanese', '', 'pkg_ja-JP', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/ja-JP_details.xml', '', '', ''),
('82', '2', '0', 'Kazakh', '', 'pkg_kk-KZ', 'package', '', '0', '4.1.2.1', '', 'https://update.joomla.org/language/details4/kk-KZ_details.xml', '', '', ''),
('83', '2', '0', 'Lithuanian', '', 'pkg_lt-LT', 'package', '', '0', '4.2.6.1', '', 'https://update.joomla.org/language/details4/lt-LT_details.xml', '', '', ''),
('84', '2', '0', 'Macedonian', '', 'pkg_mk-MK', 'package', '', '0', '4.2.4.1', '', 'https://update.joomla.org/language/details4/mk-MK_details.xml', '', '', ''),
('85', '2', '0', 'Norwegian Bokmål', '', 'pkg_nb-NO', 'package', '', '0', '4.0.1.1', '', 'https://update.joomla.org/language/details4/nb-NO_details.xml', '', '', ''),
('86', '2', '0', 'Persian Farsi', '', 'pkg_fa-IR', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/fa-IR_details.xml', '', '', ''),
('87', '2', '0', 'Polish', '', 'pkg_pl-PL', 'package', '', '0', '4.2.8.2', '', 'https://update.joomla.org/language/details4/pl-PL_details.xml', '', '', ''),
('88', '2', '0', 'Portuguese, Brazil', '', 'pkg_pt-BR', 'package', '', '0', '4.0.3.1', '', 'https://update.joomla.org/language/details4/pt-BR_details.xml', '', '', ''),
('89', '2', '0', 'Portuguese, Portugal', '', 'pkg_pt-PT', 'package', '', '0', '4.0.0-rc4.2', '', 'https://update.joomla.org/language/details4/pt-PT_details.xml', '', '', ''),
('90', '2', '0', 'Romanian', '', 'pkg_ro-RO', 'package', '', '0', '4.2.7.1', '', 'https://update.joomla.org/language/details4/ro-RO_details.xml', '', '', ''),
('91', '2', '0', 'Russian', '', 'pkg_ru-RU', 'package', '', '0', '4.2.7.1', '', 'https://update.joomla.org/language/details4/ru-RU_details.xml', '', '', ''),
('92', '2', '0', 'Serbian, Cyrillic', '', 'pkg_sr-RS', 'package', '', '0', '4.2.7.1', '', 'https://update.joomla.org/language/details4/sr-RS_details.xml', '', '', ''),
('93', '2', '0', 'Serbian, Latin', '', 'pkg_sr-YU', 'package', '', '0', '4.2.5.1', '', 'https://update.joomla.org/language/details4/sr-YU_details.xml', '', '', ''),
('94', '2', '0', 'Slovak', '', 'pkg_sk-SK', 'package', '', '0', '4.0.6.1', '', 'https://update.joomla.org/language/details4/sk-SK_details.xml', '', '', ''),
('95', '2', '0', 'Slovenian', '', 'pkg_sl-SI', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/sl-SI_details.xml', '', '', ''),
('96', '2', '0', 'Spanish', '', 'pkg_es-ES', 'package', '', '0', '4.2.3.1', '', 'https://update.joomla.org/language/details4/es-ES_details.xml', '', '', ''),
('97', '2', '0', 'Swedish', '', 'pkg_sv-SE', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/sv-SE_details.xml', '', '', ''),
('98', '2', '0', 'Tamil, India', '', 'pkg_ta-IN', 'package', '', '0', '4.2.7.1', '', 'https://update.joomla.org/language/details4/ta-IN_details.xml', '', '', ''),
('99', '2', '0', 'Thai', '', 'pkg_th-TH', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/th-TH_details.xml', '', '', ''),
('100', '2', '0', 'Turkish', '', 'pkg_tr-TR', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/tr-TR_details.xml', '', '', ''),
('101', '2', '0', 'Ukrainian', '', 'pkg_uk-UA', 'package', '', '0', '4.2.5.1', '', 'https://update.joomla.org/language/details4/uk-UA_details.xml', '', '', ''),
('102', '2', '0', 'Vietnamese', '', 'pkg_vi-VN', 'package', '', '0', '4.2.2.1', '', 'https://update.joomla.org/language/details4/vi-VN_details.xml', '', '', ''),
('103', '2', '0', 'Welsh', '', 'pkg_cy-GB', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/cy-GB_details.xml', '', '', ''),
('104', '21', '0', 'Search Extension Package', 'Joomla! CMS Search Package', 'pkg_search', 'package', '', '0', '4.0.1-dev', '', 'https://raw.githubusercontent.com/joomla-extensions/search/main/manifest.xml', 'https://github.com/joomla-extensions/search/releases/tag/4.0.1-dev', NULL, ''),
('105', '24', '0', 'Akeeba Backup Core for Joomla! 4', '', 'pkg_akeebabackup', 'package', '', '0', '9.5.1', '', 'https://cdn.akeeba.com/updates/pkgakeebabackupcore.xml', 'https://www.akeeba.com/download/akeeba-backup/9-5-1.html', NULL, '');
/**ABDB**/CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT '0',
  `extension_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';
/**ABDB**/INSERT INTO `#__update_sites_extensions`  VALUES 
('1', '700'),
('2', '802'),
('2', '10014'),
('3', '28'),
('4', '10004'),
('6', '10007'),
('7', '10008'),
('8', '10009'),
('9', '10010'),
('10', '10074'),
('11', '10011'),
('12', '10000'),
('14', '10049'),
('15', '10050'),
('16', '10051'),
('21', '10127'),
('24', '10137'),
('24', '10148'),
('24', '10150'),
('24', '10158'),
('25', '10148'),
('26', '10150'),
('27', '10158'),
('28', '10000'),
('29', '10157');
/**ABDB**/CREATE TABLE `#__update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `location` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int(11) DEFAULT '0',
  `last_check_timestamp` bigint(20) DEFAULT '0',
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites';
/**ABDB**/INSERT INTO `#__update_sites`  VALUES 
('1', 'Joomla! Core', 'collection', 'https://update.joomla.org/core/sts/list_sts.xml', '1', '1678650276', '', NULL, NULL),
('2', 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_4.xml', '1', '1678650277', '', NULL, NULL),
('3', 'Joomla! Update Component', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', '1', '1678650277', '', NULL, NULL),
('4', 'System - Helix Ultimate Framework', 'extension', 'http://www.joomshaper.com/updates/plg-system-helixultimate.xml', '1', '1678650277', '', NULL, NULL),
('6', 'SP Simple Portfolio', 'extension', 'http://www.joomshaper.com/updates/com-sp-simple-portfolio.xml', '1', '1678650277', '', NULL, NULL),
('7', 'SP Easy Image Gallery', 'extension', 'https://www.joomshaper.com/updates/com-sp-easyimagegallery.xml', '1', '1678650277', '', NULL, NULL),
('8', 'SP Easy Image Gallery Module', 'extension', 'https://www.joomshaper.com/updates/mod-sp-easyimagegallery.xml', '1', '1678650278', '', NULL, NULL),
('9', 'SP Simple Portfolio Module', 'extension', 'http://www.joomshaper.com/updates/mod-sp-simple-portfolio.xml', '1', '1678650278', '', NULL, NULL),
('10', 'shaper_helixultimate', 'extension', 'https://www.joomshaper.com/updates/shaper-helixultimate.xml', '1', '1678650278', '', NULL, NULL),
('11', 'WebInstaller Update Site', 'extension', 'https://appscdn.joomla.org/webapps/jedapps/webinstaller.xml', '1', '1678650279', '', NULL, NULL),
('12', 'SP Page Builder', 'extension', 'https://www.joomshaper.com/updates/com-sp-page-builder-pro.xml', '0', '0', 'joomshaper_email=office%40diablodesign.eu&amp;joomshaper_license_key=b9b23502acc29e3aaca2925d5b0a7b2d', NULL, NULL),
('14', 'ruxin_bmi_calculator', 'extension', 'http://ruxincode.com/update/ruxin_bmi_calculator.xml', '1', '1678650280', '', NULL, NULL),
('15', 'ruxin_news', 'extension', 'http://www.ruxincode.com/update/ruxin_news.xml', '1', '1678650280', '', NULL, NULL),
('16', 'FOF 3.x', 'extension', 'http://cdn.akeeba.com/updates/fof3_file.xml', '1', '1678650281', '', NULL, NULL),
('21', 'Search Update Site', 'extension', 'https://raw.githubusercontent.com/joomla-extensions/search/main/manifest.xml', '1', '1678650281', '', NULL, NULL),
('24', 'Akeeba Backup Core for Joomla!', 'extension', 'https://cdn.akeeba.com/updates/pkgakeebabackupcore.xml', '1', '1678650281', '', NULL, NULL),
('25', 'Akeeba Backup Core for Joomla!', 'extension', 'https://cdn.akeeba.com/updates/pkgakeebabackupcore.xml', '1', '1678650281', '', NULL, NULL),
('26', 'Akeeba Backup Core for Joomla!', 'extension', 'https://cdn.akeeba.com/updates/pkgakeebabackupcore.xml', '1', '1678650281', '', NULL, NULL),
('27', 'Akeeba Backup Core for Joomla!', 'extension', 'https://cdn.akeeba.com/updates/pkgakeebabackupcore.xml', '1', '1678650281', '', NULL, NULL),
('28', 'SP Page Builder', 'extension', 'https://www.joomshaper.com/updates/com-sp-page-builder-pro-next.xml', '1', '1678650281', '', NULL, NULL),
('29', 'Akeeba Backup Core for Joomla!', 'extension', 'https://cdn.akeeba.com/updates/pkgakeebabackupcore.xml', '1', '0', '', NULL, NULL);
/**ABDB**/CREATE TABLE `#__ucm_content` (
  `core_content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext COLLATE utf8mb4_unicode_ci,
  `core_state` tinyint(1) NOT NULL DEFAULT '0',
  `core_checked_out_time` datetime DEFAULT NULL,
  `core_checked_out_user_id` int(10) unsigned DEFAULT NULL,
  `core_access` int(10) unsigned NOT NULL DEFAULT '0',
  `core_params` text COLLATE utf8mb4_unicode_ci,
  `core_featured` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `core_metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL,
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL,
  `core_language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_publish_up` datetime DEFAULT NULL,
  `core_publish_down` datetime DEFAULT NULL,
  `core_content_item_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `core_images` text COLLATE utf8mb4_unicode_ci,
  `core_urls` text COLLATE utf8mb4_unicode_ci,
  `core_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `core_version` int(10) unsigned NOT NULL DEFAULT '1',
  `core_ordering` int(11) NOT NULL DEFAULT '0',
  `core_metakey` text COLLATE utf8mb4_unicode_ci,
  `core_metadesc` text COLLATE utf8mb4_unicode_ci,
  `core_catid` int(10) unsigned NOT NULL DEFAULT '0',
  `core_xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_language` (`core_language`),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_content_type` (`core_type_alias`(100)),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields';
/**ABDB**/CREATE TABLE `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(10) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__template_styles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `home` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `inheritable` tinyint(4) NOT NULL DEFAULT '0',
  `parent` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_home` (`client_id`,`home`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__template_styles`  VALUES 
('14', 'shaper_helixultimate', '0', '1', 'shaper_helixultimate - Default', '{\"logo_type\":\"image\",\"logo_image\":\"images\\/logobbn.png\",\"retina_logo\":\"images\\/logobbn.png\",\"mobile_logo\":\"images\\/logobbn.png\",\"logo_alt\":\"\",\"logo_height\":\"60px\",\"logo_height_sm\":\"36px\",\"logo_height_xs\":\"36px\",\"logo_text\":\"\",\"logo_slogan\":\"\",\"favicon\":\"\",\"predefined_header\":\"1\",\"header_style\":\"style-2\",\"header_height\":\"60px\",\"header_height_sm\":\"\",\"header_height_xs\":\"\",\"sticky_header\":\"1\",\"sticky_offset\":\"\",\"loader_type\":\"circle\",\"body_bg_image\":\"\",\"body_bg_repeat\":\"inherit\",\"body_bg_position\":\"0 0\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"enabled_copyright\":\"1\",\"copyright_position\":\"footer1\",\"copyright_load_pos\":\"default\",\"copyright\":\"\\u00a9 {year} Body Bulder.  Designed By <span style=\\\"color: #f44336;\\\">\\u2764<\\/span><a title=\\\"DiabloDesign\\\" href=\\\"https:\\/\\/diablodesign.eu\\\" target=\\\"_blank\\\" rel=\\\"author\\\">DiabloDesign<\\/a>\",\"goto_top\":\"1\",\"social_position\":\"top1\",\"social_load_pos\":\"default\",\"facebook\":\"#\",\"twitter\":\"#\",\"pinterest\":\"\",\"linkedin\":\"\",\"dribbble\":\"\",\"instagram\":\"#\",\"behance\":\"\",\"youtube\":\"\",\"flickr\":\"\",\"skype\":\"\",\"whatsapp\":\"\",\"vk\":\"\",\"custom\":\"\",\"contactinfo\":\"1\",\"contact_position\":\"top2\",\"contact_load_pos\":\"default\",\"contact_phone\":\"+228 872 4444\",\"contact_mobile\":\"+775 872 4444\",\"contact_email\":\"contact@email.com\",\"contact_time\":\"\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_content\":\"Coming soon content\",\"comingsoon_date\":\"1-1-2025\",\"comingsoon_logo\":\"\",\"comingsoon_bg_image\":\"\",\"error_logo\":\"images\\/logobbn.png\",\"error_bg\":\"images\\/grunge-brick-wall-background.jpg\",\"presets-data\":\"{\\\"preset1\\\":{\\\"label\\\":\\\"Preset 1\\\",\\\"default\\\":\\\"#0345BF\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0345BF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0345BF\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_text_active_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0345BF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\",\\\"preset\\\":\\\"preset1\\\"}},\\\"preset2\\\":{\\\"label\\\":\\\"Preset 2\\\",\\\"default\\\":\\\"#ec430f\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"bg_color\\\":\\\"#ffffff\\\",\\\"link_color\\\":\\\"#ec430f\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ec430f\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_text_active_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ec430f\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset3\\\":{\\\"label\\\":\\\"Preset 3\\\",\\\"default\\\":\\\"#0fa89d\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"bg_color\\\":\\\"#ffffff\\\",\\\"link_color\\\":\\\"#2C5F2D\\\",\\\"link_hover_color\\\":\\\"#fff\\\",\\\"header_bg_color\\\":\\\"#ffffff\\\",\\\"topbar_bg_color\\\":\\\"#03a83a\\\",\\\"topbar_text_color\\\":\\\"#ffffff\\\",\\\"logo_text_color\\\":\\\"#2C5F2D\\\",\\\"menu_text_color\\\":\\\"#03a83a\\\",\\\"menu_text_hover_color\\\":\\\"#030000\\\",\\\"menu_text_active_color\\\":\\\"#063803\\\",\\\"menu_dropdown_bg_color\\\":\\\"#2C5F2D\\\",\\\"menu_dropdown_text_color\\\":\\\"#2C5F2D\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#2C5F2D\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#2C5F2D\\\",\\\"footer_bg_color\\\":\\\"#2C5F2D\\\",\\\"footer_text_color\\\":\\\"#2C5F2D\\\",\\\"footer_link_color\\\":\\\"#2C5F2D\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset4\\\":{\\\"label\\\":\\\"Preset 4\\\",\\\"default\\\":\\\"#4943ac\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset4\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4943ac\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4943ac\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_text_active_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4943ac\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset5\\\":{\\\"label\\\":\\\"Preset 5\\\",\\\"default\\\":\\\"#00aeef\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset5\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#00aeef\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#00aeef\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_text_active_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#00aeef\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset6\\\":{\\\"label\\\":\\\"Preset 6\\\",\\\"default\\\":\\\"#f68e13\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset6\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#f68e13\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#f68e13\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_text_active_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#f68e13\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset7\\\":{\\\"label\\\":\\\"Preset 7\\\",\\\"default\\\":\\\"#2ba84a\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset7\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#2ba84a\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#2ba84a\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_text_active_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#2ba84a\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset8\\\":{\\\"label\\\":\\\"Preset 8\\\",\\\"default\\\":\\\"#ed145b\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset8\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ed145b\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ed145b\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_text_active_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ed145b\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}}}\",\"preset\":\"{\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_text_active_color\\\":\\\"#ec430f\\\",\\\"menu_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"logo_text_color\\\":\\\"#ec430f\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"link_color\\\":\\\"#ec430f\\\",\\\"bg_color\\\":\\\"#ffffff\\\",\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset2\\\"}\",\"topbar_bg_color\":\"#333333\",\"topbar_text_color\":\"#aaaaaa\",\"header_bg_color\":\"#ffffff\",\"logo_text_color\":\"#2b2b2b\",\"menu_text_color\":\"#252525\",\"menu_text_hover_color\":\"#0345bf\",\"menu_text_active_color\":\"#0345bf\",\"menu_dropdown_bg_color\":\"#ffffff\",\"menu_dropdown_text_color\":\"#252525\",\"menu_dropdown_text_hover_color\":\"#0345bf\",\"menu_dropdown_text_active_color\":\"#0345bf\",\"text_color\":\"#252525\",\"bg_color\":\"#ffffff\",\"link_color\":\"#0345bf\",\"link_hover_color\":\"#044cd0\",\"footer_bg_color\":\"#171717\",\"footer_text_color\":\"#ffffff\",\"footer_link_color\":\"#a2a2a2\",\"footer_link_hover_color\":\"#ffffff\",\"name\":\"\",\"custom_class\":\"\",\"padding\":\"\",\"margin\":\"\",\"layout\":\"[{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_desktop\\\":0,\\\"hide_small_desktop\\\":0,\\\"hide_tablet\\\":0,\\\"hide_large_mobile\\\":1,\\\"hide_mobile\\\":1,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"name\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"title\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":12,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+4+4\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"name\\\":\\\"Main Body\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"left\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":4,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"grid_size\\\":4}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"right\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":4,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"3+3+3+3\\\",\\\"settings\\\":{\\\"name\\\":\\\"Bottom\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"column_type\\\":0,\\\"name\\\":\\\"bottom1\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"col-sm-6\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"grid_size\\\":3}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"col-sm-6\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"bottom2\\\",\\\"column_type\\\":0,\\\"grid_size\\\":3}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":3,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"bottom3\\\",\\\"column_type\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":3,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"bottom4\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"6+6\\\",\\\"settings\\\":{\\\"name\\\":\\\"Footer\\\",\\\"background_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"grid_size\\\":6,\\\"column_type\\\":0,\\\"name\\\":\\\"footer1\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":6,\\\"column_type\\\":0,\\\"name\\\":\\\"footer2\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\"}}]}]\",\"menu\":\"mainmenu\",\"menu_type\":\"mega_offcanvas\",\"dropdown_width\":\"\",\"menu_animation\":\"menu-animation-fade-up\",\"offcanvas_position\":\"right\",\"offcanvas_style\":\"1-LeftAlign\",\"offcanvas_menu\":\"mainmenu\",\"offcanvas_max_level\":\"0\",\"hu-webfont-size-field\":\"\",\"hu-webfont-size-field-sm\":\"\",\"hu-webfont-size-field-xs\":\"\",\"hu-font-letter-spacing-input\":\"\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Helvetica\\\",\\\"fontSize\\\":\\\"36px\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_navigation_font\":\"1\",\"navigation_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font_selectors\":\"\",\"image_thumbnail_size\":\"600X340\",\"image_small_size\":\"100X100\",\"image_medium_size\":\"300X300\",\"image_large_size\":\"600X600\",\"image_crop_quality\":\"100\",\"blog_list_image\":\"thumbnail\",\"leading_blog_list_image\":\"large\",\"blog_details_image\":\"default\",\"social_share\":\"1\",\"social_share_lists\":[\"facebook\",\"twitter\",\"linkedin\"],\"og_fb_id\":\"\",\"og_twitter_site\":\"\",\"reading_timeline_bg\":\"#0345bf\",\"reading_timeline_height\":\"5px\",\"reading_timeline_position\":\"top\",\"related_article_title\":\"Related Articles\",\"related_article_limit\":\"3\",\"related_article_view_type\":\"thumb\",\"comment\":\"disabled\",\"comment_disqus_subdomain\":\"\",\"comment_intensedebate_acc\":\"\",\"comment_facebook_app_id\":\"\",\"comment_facebook_width\":\"100\",\"comment_facebook_number\":\"10\",\"before_head\":\"\",\"after_body\":\"\",\"before_body\":\"\",\"custom_css\":\"\",\"custom_js\":\"\",\"exclude_js\":\"\",\"scssoption\":\"1\",\"enable_fontawesome\":\"1\",\"gfont_api\":\"\",\"ga_code\":\"\",\"ga_tracking_method\":\"\",\"id\":\"14\",\"template\":\"shaper_helixultimate\",\"client_id\":\"0\",\"home\":\"1\",\"title\":\"shaper_helixultimate - Default\"}', '0', ''),
('15', 'atum', '1', '1', 'Atum - Default', '{\"hue\":\"hsl(214, 63%, 20%)\",\"bg-light\":\"#f0f4fb\",\"text-dark\":\"#495057\",\"text-light\":\"#ffffff\",\"link-color\":\"#2a69b8\",\"special-color\":\"#001b4c\",\"monochrome\":\"0\",\"loginLogo\":\"\",\"loginLogoAlt\":\"\",\"logoBrandLarge\":\"\",\"logoBrandLargeAlt\":\"\",\"logoBrandSmall\":\"\",\"logoBrandSmallAlt\":\"\"}', '1', ''),
('16', 'cassiopeia', '0', '0', 'Cassiopeia - Default', '{}', '1', '');
/**ABDB**/CREATE TABLE `#__template_overrides` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hash_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension_id` int(11) DEFAULT '0',
  `state` tinyint(4) NOT NULL DEFAULT '0',
  `action` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_date` datetime NOT NULL,
  `modified_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_extension_id` (`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__tags`  VALUES 
('1', '0', '0', '15', '0', '', 'ROOT', 'root', '', '', '1', NULL, NULL, '1', '', '', '', '', '580', '2020-12-19 21:19:52', '', '580', '2020-12-19 21:19:52', '', '', '0', '*', '1', NULL, NULL),
('2', '1', '1', '2', '1', 'animations', 'Animations', 'animations', '', '', '1', NULL, '2018-02-26 06:42:28', '1', '{}', '', '', '{}', '580', '2020-12-19 21:19:52', '', '0', '2020-12-19 21:19:52', '{}', '{}', '0', '*', '1', '2020-12-19 21:19:52', '2020-12-19 21:19:52'),
('3', '1', '3', '4', '1', 'builder', 'Builder', 'builder', '', '', '1', NULL, '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '580', '2020-12-19 21:19:52', '', '0', '2020-12-19 21:19:52', '{}', '{}', '0', '*', '1', '2020-12-19 21:19:52', '2020-12-19 21:19:52'),
('4', '1', '5', '6', '1', 'dropdown', 'Dropdown', 'dropdown', '', '', '1', NULL, '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '580', '2020-12-19 21:19:52', '', '0', '2020-12-19 21:19:52', '{}', '{}', '0', '*', '1', '2020-12-19 21:19:52', '2020-12-19 21:19:52'),
('5', '1', '7', '8', '1', 'drag', 'Drag', 'drag', '', '', '1', NULL, '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '580', '2020-12-19 21:19:52', '', '0', '2020-12-19 21:19:52', '{}', '{}', '0', '*', '1', '2020-12-19 21:19:52', '2020-12-19 21:19:52'),
('6', '1', '9', '10', '1', 'drop', 'Drop', 'drop', '', '', '1', NULL, '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '580', '2020-12-19 21:19:52', '', '0', '2020-12-19 21:19:52', '{}', '{}', '0', '*', '1', '2020-12-19 21:19:52', '2020-12-19 21:19:52'),
('7', '1', '11', '12', '1', 'mega-menu', 'Mega Menu', 'mega-menu', '', '', '1', NULL, '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '580', '2020-12-19 21:19:52', '', '0', '2020-12-19 21:19:52', '{}', '{}', '0', '*', '1', '2020-12-19 21:19:52', '2020-12-19 21:19:52'),
('8', '1', '13', '14', '1', 'features', 'Features', 'features', '', '', '1', NULL, '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '580', '2020-12-19 21:19:52', '', '0', '2020-12-19 21:19:52', '{}', '{}', '0', '*', '1', '2020-12-19 21:19:52', '2020-12-19 21:19:52');
/**ABDB**/CREATE TABLE `#__spsimpleportfolio_tags` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(55) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__spsimpleportfolio_tags`  VALUES 
('1', 'Home', 'home'),
('2', 'Office', 'office'),
('3', 'Outdoor', 'outdoor');
/**ABDB**/CREATE TABLE `#__spsimpleportfolio_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(55) NOT NULL,
  `catid` int(11) NOT NULL,
  `image` text NOT NULL,
  `thumbnail` text NOT NULL,
  `video` text NOT NULL,
  `description` mediumtext,
  `client` varchar(100) NOT NULL,
  `client_avatar` text NOT NULL,
  `tagids` text NOT NULL,
  `url` text NOT NULL,
  `published` tinyint(3) NOT NULL DEFAULT '1',
  `language` varchar(255) NOT NULL DEFAULT '*',
  `access` int(5) NOT NULL DEFAULT '1',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__spsimpleportfolio_items`  VALUES 
('1', 'Visualize impactful mindshare', 'visualize-impactful-mindshare', '0', 'images/spsimpleportfolio/portfolio1.jpg', '', '', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown.</p>\r\n<p><strong>Intro</strong><br />Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.</p>\r\n<p> <br /><strong>Case Study</strong><br />Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.</p>', 'JoomShaper', '', '[\"1\"]', 'http://www.joomshaper.com', '1', '*', '1', '0', '871', '2018-02-22 08:13:49', '0', '0000-00-00 00:00:00', '0', '0000-00-00 00:00:00'),
('2', 'Enable value-added convergence', 'enable-value-added-convergence', '0', 'images/spsimpleportfolio/portfolio2.jpg', '', '', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown.</p>\r\n<p><strong>Intro</strong><br />Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.</p>\r\n<p> <br /><strong>Case Study</strong><br />Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.</p>', 'JoomShaper', '', '[\"2\"]', 'http://www.joomshaper.com', '1', '*', '1', '0', '871', '2018-02-22 08:21:28', '0', '0000-00-00 00:00:00', '0', '0000-00-00 00:00:00'),
('3', 'Visualize vertical interfaces', 'visualize-vertical-interfaces', '0', 'images/spsimpleportfolio/portfolio3.jpg', '', '', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown.</p>\r\n<p><strong>Intro</strong><br />Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.</p>\r\n<p> <br /><strong>Case Study</strong><br />Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.</p>', 'JoomShaper', '', '[\"1\"]', 'http://www.joomshaper.com', '1', '*', '1', '0', '871', '2018-02-22 08:50:28', '0', '0000-00-00 00:00:00', '0', '0000-00-00 00:00:00'),
('4', 'Integrate clicks-and-mortar methodologies', 'integrate-clicks-and-mortar-methodologies', '0', 'images/spsimpleportfolio/portfolio4.jpg', '', '', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown.</p>\r\n<p><strong>Intro</strong><br />Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.</p>\r\n<p> <br /><strong>Case Study</strong><br />Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.</p>', 'JoomShaper', '', '[\"3\"]', 'http://www.joomshaper.com', '1', '*', '1', '0', '871', '2018-02-22 08:52:48', '0', '0000-00-00 00:00:00', '0', '0000-00-00 00:00:00'),
('5', 'Streamline customized models', 'streamline-customized-models', '0', 'images/spsimpleportfolio/portfolio5.jpg', '', '', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown.</p>\r\n<p><strong>Intro</strong><br />Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.</p>\r\n<p> <br /><strong>Case Study</strong><br />Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.</p>', 'JoomShaper', '', '[\"3\"]', 'http://www.joomshaper.com', '1', '*', '1', '0', '871', '2018-02-22 08:59:50', '0', '0000-00-00 00:00:00', '0', '0000-00-00 00:00:00'),
('6', 'Architect ubiquitous deliverables', 'architect-ubiquitous-deliverables', '0', 'images/spsimpleportfolio/portfolio6.jpg', '', '', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown.</p>\r\n<p><strong>Intro</strong><br />Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.</p>\r\n<p> <br /><strong>Case Study</strong><br />Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.</p>', 'JoomShaper', '', '[\"1\"]', 'http://www.joomshaper.com', '1', '*', '1', '0', '871', '2018-02-22 09:01:08', '0', '0000-00-00 00:00:00', '0', '0000-00-00 00:00:00'),
('7', 'Repurpose viral metrics', 'repurpose-viral-metrics', '0', 'images/spsimpleportfolio/portfolio7.jpg', '', '', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown.</p>\r\n<p><strong>Intro</strong><br />Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.</p>\r\n<p> <br /><strong>Case Study</strong><br />Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.</p>', 'JoomShaper', '', '[\"1\"]', 'http://www.joomshaper.com', '1', '*', '1', '0', '871', '2018-02-22 09:02:35', '0', '0000-00-00 00:00:00', '0', '0000-00-00 00:00:00'),
('8', 'Matrix holistic deliverables', 'matrix-holistic-deliverables', '0', 'images/spsimpleportfolio/portfolio8.jpg', '', '', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown.</p>\r\n<p><strong>Intro</strong><br />Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.</p>\r\n<p> <br /><strong>Case Study</strong><br />Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.</p>', 'JoomShaper', '', '[\"2\"]', 'http://www.joomshaper.com', '1', '*', '1', '0', '871', '2018-02-22 09:04:02', '0', '0000-00-00 00:00:00', '0', '0000-00-00 00:00:00');
/**ABDB**/CREATE TABLE `#__sppagebuilder_sections` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `section` mediumtext NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder_languages` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `lang_tag` varchar(255) NOT NULL DEFAULT '',
  `lang_key` varchar(100) DEFAULT NULL,
  `version` varchar(255) NOT NULL DEFAULT '',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder_integrations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `component` varchar(255) NOT NULL DEFAULT '',
  `plugin` mediumtext NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder_assets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `assets` text NOT NULL,
  `css_path` text,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `access` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder_addons` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `code` mediumtext NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__sppagebuilder_addons`  VALUES 
('2', 'title', '{\"id\":1608971953396,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Diet Blog Latest News...\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"md\":\"47\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px   30px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":{\"ho\":0,\"vo\":\"2\",\"blur\":\"0\",\"spread\":0,\"color\":\"#ffffff\",\"inset\":false},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608971953396,\"title_font_family\":\"Reenie Beanie\",\"global_text_color\":\"#3a0000\",\"title_font_style\":{\"weight\":400}}}', '2020-12-26 20:30:48', '580');
/**ABDB**/CREATE TABLE `#__sppagebuilder_addonlist` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `ordering` int(5) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `text` mediumtext NOT NULL,
  `extension` varchar(255) NOT NULL DEFAULT 'com_sppagebuilder',
  `extension_view` varchar(255) NOT NULL DEFAULT 'page',
  `view_id` bigint(20) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(3) NOT NULL DEFAULT '1',
  `catid` int(10) NOT NULL DEFAULT '0',
  `access` int(10) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `checked_out` int(10) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[]',
  `og_title` varchar(255) NOT NULL DEFAULT '',
  `og_image` varchar(255) NOT NULL DEFAULT '',
  `og_description` varchar(255) NOT NULL DEFAULT '',
  `language` char(7) NOT NULL DEFAULT '',
  `hits` bigint(20) NOT NULL DEFAULT '0',
  `css` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__sppagebuilder`  VALUES 
('1', '60', 'Home', '[{\"id\":1606549126439,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":1,\"no_gutter\":0,\"padding\":{\"xxl\":\"0px 0px 2px 0px\",\"xl\":\"0px 0px 2px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"show_top_shape\":0,\"shape_name\":\"turning-slope\",\"shape_color\":\"rgba(255, 255, 255, 0.5)\",\"shape_width\":{\"xxl\":\"258\",\"xl\":\"258\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"34\",\"xl\":\"34\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":1,\"shape_invert\":1,\"shape_to_front\":1,\"show_bottom_shape\":1,\"bottom_shape_name\":\"slope-opacity\",\"bottom_shape_color\":\"\",\"bottom_shape_width\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"106\",\"xl\":\"106\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":0,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1606549126439,\"slider_settings\":\"slider_global\",\"controllers\":\"dot\",\"row_border\":0,\"row_border_width\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},\"layout\":\"12\",\"columns\":[{\"id\":1606549126450,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#fff\",\"inset\":false,\"enabled\":false},\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1606549126450,\"row_boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"column_height\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"}},\"addons\":[{\"id\":1606549126451,\"name\":\"js_slideshow\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"slider_settings\":\"slider_global\",\"height\":\"custom\",\"custom_height\":{\"xxl\":900,\"xl\":900,\"lg\":600,\"md\":600,\"sm\":\"550\",\"xs\":\"550\"},\"slider_animation\":\"fade\",\"slide_vertically\":1,\"three_d_rotate\":15,\"autoplay\":1,\"interval\":5,\"speed\":\"1000\",\"timer\":0,\"timer_position\":\"bottom\",\"timer_bg_color\":\"#ababab\",\"class\":\"\",\"controllers\":\"dot\",\"dot_controllers\":1,\"dot_controllers_style\":\"line\",\"line_indecator\":1,\"dot_controllers_position\":\"vertical_left\",\"dot_controllers_bottom_gap\":{\"xxl\":\"105\",\"xl\":\"105\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"dot_controllers_left_gap\":{\"xxl\":\"86\",\"xl\":\"86\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"dot_controllers_right_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"dot_controller_style_option\":\"dot_active\",\"dot_ctlr_height\":\"1\",\"dot_ctlr_width\":\"39\",\"dot_ctlr_bg\":\"#ffffff\",\"dot_ctlr_border_width\":\"0\",\"dot_ctlr_border_color\":\"\",\"dot_ctlr_border_radius\":\"0\",\"dot_ctlr_margin\":\"   \",\"dot_ctlr_center_bg\":\"#ff0000\",\"dot_ctlr_hover_height\":\"1\",\"dot_ctlr_hover_width\":\"62\",\"dot_ctlr_hover_border_color\":\"\",\"arrow_controllers\":0,\"arrow_on_hover\":0,\"arrow_controllers_style\":\"spread\",\"arrow_controllers_content\":\"icon_only\",\"arrow_controllers_position\":\"bottom_center\",\"arrow_controllers_bottom_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_controllers_left_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_controllers_right_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_spread_controllers_left_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_spread_controllers_right_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_style\":\"arrow_normal\",\"arrow_ctlr_width\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_ctlr_height\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_ctlr_color\":\"\",\"arrow_ctlr_font_size\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_ctlr_background\":\"\",\"arrow_ctlr_border_width\":\"\",\"arrow_ctlr_border_color\":\"\",\"arrow_ctlr_border_radius\":\"\",\"arrow_ctlr_hover_background\":\"\",\"arrow_ctlr_hover_color\":\"\",\"arrow_ctlr_hover_border_color\":\"\",\"content_container_width\":{\"xxl\":\"45\",\"xl\":\"45\",\"lg\":\"85\",\"md\":\"85\",\"sm\":\"95\",\"xs\":\"95\"},\"content_vertical_alignment\":1,\"slideshow_items\":[{\"title\":\"slide-1\",\"slider_img\":{\"src\":\"images\\/2021\\/01\\/05\\/strong-bodybuilder-posing-and-showing-muscles.jpg\",\"height\":1333,\"width\":2000},\"slideshow_inner_items\":[{\"title\":\"ATHLETE FITNES CLUB\",\"content_tabs\":\"content_style\",\"content_type\":\"title_content\",\"title_content_title\":\"ATHLETIC FITNES\\n\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"right\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"73\",\"xl\":\"73\",\"lg\":\"\",\"md\":\"\",\"sm\":\"30\",\"xs\":\"30\"},\"content_lineheight\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"10px 10px 10px 10px\",\"xl\":\"10px 10px 10px 10px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Krona One\",\"content_text_shadow\":{\"ho\":\"17\",\"vo\":0,\"blur\":\"56\",\"spread\":0,\"color\":\"#ffffff\",\"inset\":false}},{\"content_tabs\":\"content_style\",\"content_type\":\"title_content\",\"title_content_title\":\"CLUB\",\"content_border\":\"   \",\"content_margin\":{\"xxl\":\"0px   \",\"xl\":\"0px   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_font_family\":\"Krona One\",\"content_color\":\"#ffffff\",\"title\":\"club\",\"content_font_style\":{\"weight\":100,\"italic\":true},\"content_animation_type\":\"text-animate\",\"animation_slide_direction\":\"left\",\"content_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_text_shadow\":{\"ho\":0,\"vo\":\"5\",\"blur\":\"38\",\"spread\":0,\"color\":\"#fa0707\",\"inset\":false}},{\"title\":\"Text\",\"content_tabs\":\"content_type\",\"content_type\":\"text_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"<div style=\\\"text-align: justify;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do<\\/div>\\n<div style=\\\"text-align: justify;\\\">eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<\\/div>\\n<div style=\\\"text-align: justify;\\\">enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<\\/div>\\n<div style=\\\"text-align: justify;\\\">ut aliquip ex ea commodo consequat.<\\/div>\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"14\",\"xs\":\"14\"},\"content_lineheight\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"25px 0px 0px 0px\",\"xl\":\"25px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":false,\"weight\":400},\"content_font_family\":\"Oxygen\"},{\"title\":\"Button\",\"content_tabs\":\"content_type\",\"content_type\":\"btn_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Read More\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_lineheight\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"rgba(68, 68, 68, 0)\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"1px 1px 1px 1px\",\"content_border_color\":\"#ffffff\",\"content_border_radius\":\"0\",\"content_margin\":{\"xxl\":\"50px 0px 0px 0px\",\"xl\":\"50px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"40px 0px 0px 0px\",\"xs\":\"40px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"17px 40px 15px 40px\",\"xl\":\"17px 40px 15px 40px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#000000\",\"button_background_color_hover\":\"rgba(255, 255, 255, 0.59)\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"rgba(135, 135, 135, 0.7)\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"}],\"image_in_column\":0,\"image_column_width\":{\"xxl\":6,\"xl\":6,\"lg\":6,\"md\":6,\"sm\":6,\"xs\":6},\"image_column_reverse\":0,\"image_content_alignment\":\"left\",\"content_alignment\":\"right\",\"icon_display_block\":0,\"enable_youtube_vimeo\":0,\"video_volume_btn\":0,\"slider_bg_options\":\"bg_image\",\"slider_overlay_options\":\"gradient_overaly\",\"slider_bg_gradient_overlay\":{\"color\":\"rgba(255, 0, 0, 0.48)\",\"color2\":\"rgba(0, 0, 0, 0.42)\",\"deg\":\"123\",\"pos\":\"18\",\"pos2\":\"60\",\"type\":\"radial\",\"radialPos\":\"top left\"}},{\"title\":\"slide-2\",\"slider_img\":{\"src\":\"images\\/2020\\/12\\/19\\/black-white-image-fit-young-woman-great-shape-lifting.jpg\",\"height\":2249,\"width\":4000},\"slideshow_inner_items\":[{\"title\":\"PROFESSIONAL STAFF\",\"content_tabs\":\"content_style\",\"content_type\":\"title_content\",\"title_content_title\":\"PROFESSIONAL STAFF\\n\\n\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"right\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"60\",\"xl\":\"60\",\"lg\":\"\",\"md\":\"\",\"sm\":\"30\",\"xs\":\"30\"},\"content_lineheight\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"10px 10px 10px 10px\",\"xl\":\"10px 10px 10px 10px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Krona One\",\"content_text_shadow\":{\"ho\":\"17\",\"vo\":0,\"blur\":\"56\",\"spread\":0,\"color\":\"#ffffff\",\"inset\":false}},{\"content_tabs\":\"content_style\",\"content_type\":\"title_content\",\"title_content_title\":\"CHECK ON YOUR OWN\",\"content_border\":\"   \",\"content_margin\":{\"xxl\":\"0px 40px  \",\"xl\":\"0px 40px  \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_font_family\":\"Krona One\",\"content_color\":\"#ffffff\",\"title\":\"CHECK ON YOUR OWN\",\"content_font_style\":{\"weight\":100,\"italic\":true},\"content_animation_type\":\"text-animate\",\"animation_slide_direction\":\"left\",\"content_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_text_shadow\":{\"ho\":0,\"vo\":\"5\",\"blur\":\"38\",\"spread\":0,\"color\":\"#fa0707\",\"inset\":false}},{\"title\":\"Text\",\"content_tabs\":\"content_type\",\"content_type\":\"text_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"<div style=\\\"text-align: justify;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do<\\/div>\\n<div style=\\\"text-align: justify;\\\">eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<\\/div>\\n<div style=\\\"text-align: justify;\\\">enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<\\/div>\\n<div style=\\\"text-align: justify;\\\">ut aliquip ex ea commodo consequat.<\\/div>\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"14\",\"xs\":\"14\"},\"content_lineheight\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"25px 0px 0px 0px\",\"xl\":\"25px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":false,\"weight\":400},\"content_font_family\":\"Oxygen\"},{\"title\":\"Button\",\"content_tabs\":\"content_type\",\"content_type\":\"btn_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Read More\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_lineheight\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"rgba(68, 68, 68, 0)\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"1px 1px 1px 1px\",\"content_border_color\":\"#ffffff\",\"content_border_radius\":\"0\",\"content_margin\":{\"xxl\":\"50px 0px 0px 0px\",\"xl\":\"50px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"40px 0px 0px 0px\",\"xs\":\"40px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"17px 40px 15px 40px\",\"xl\":\"17px 40px 15px 40px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#000000\",\"button_background_color_hover\":\"rgba(255, 255, 255, 0.59)\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"rgba(135, 135, 135, 0.7)\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"}],\"image_in_column\":0,\"image_column_width\":{\"xxl\":6,\"xl\":6,\"lg\":6,\"md\":6,\"sm\":6,\"xs\":6},\"image_column_reverse\":0,\"image_content_alignment\":\"left\",\"content_alignment\":\"right\",\"icon_display_block\":0,\"enable_youtube_vimeo\":0,\"video_volume_btn\":0,\"slider_bg_options\":\"bg_image\",\"slider_overlay_options\":\"gradient_overaly\",\"slider_bg_gradient_overlay\":{\"color\":\"rgba(255, 0, 0, 0.48)\",\"color2\":\"rgba(0, 0, 0, 0.42)\",\"deg\":\"123\",\"pos\":\"18\",\"pos2\":\"60\",\"type\":\"radial\",\"radialPos\":\"top left\"}},{\"title\":\"slide-3\",\"slider_img\":{\"src\":\"images\\/2020\\/12\\/19\\/young-beautiful-woman-training-gym.jpg\",\"height\":1306,\"width\":2000},\"slideshow_inner_items\":[{\"title\":\"5,000 SQUARE METERS\",\"content_tabs\":\"content_type\",\"content_type\":\"title_content\",\"title_content_title\":\"5,000 SQUARE METERS\\n\\n\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"right\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"60\",\"xl\":\"60\",\"lg\":\"\",\"md\":\"\",\"sm\":\"30\",\"xs\":\"30\"},\"content_lineheight\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"10px 10px 10px 10px\",\"xl\":\"10px 10px 10px 10px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Krona One\",\"content_text_shadow\":{\"ho\":\"17\",\"vo\":0,\"blur\":\"56\",\"spread\":0,\"color\":\"#ffffff\",\"inset\":false}},{\"content_tabs\":\"content_type\",\"content_type\":\"title_content\",\"title_content_title\":\"AT YOUR SERVICE\",\"content_border\":\"   \",\"content_margin\":{\"xxl\":\"0px 40px  \",\"xl\":\"0px 40px  \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_font_family\":\"Krona One\",\"content_color\":\"#ffffff\",\"title\":\"AT YOUR SERVICE\",\"content_font_style\":{\"weight\":100,\"italic\":true},\"content_animation_type\":\"text-animate\",\"animation_slide_direction\":\"left\",\"content_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_text_shadow\":{\"ho\":0,\"vo\":\"5\",\"blur\":\"38\",\"spread\":0,\"color\":\"#fa0707\",\"inset\":false}},{\"title\":\"Text\",\"content_tabs\":\"content_type\",\"content_type\":\"text_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"<div style=\\\"text-align: justify;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do<\\/div>\\n<div style=\\\"text-align: justify;\\\">eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<\\/div>\\n<div style=\\\"text-align: justify;\\\">enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<\\/div>\\n<div style=\\\"text-align: justify;\\\">ut aliquip ex ea commodo consequat.<\\/div>\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"14\",\"xs\":\"14\"},\"content_lineheight\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"25px 0px 0px 0px\",\"xl\":\"25px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":false,\"weight\":400},\"content_font_family\":\"Oxygen\"},{\"title\":\"Button\",\"content_tabs\":\"content_type\",\"content_type\":\"btn_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Read More\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_lineheight\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"rgba(68, 68, 68, 0)\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"1px 1px 1px 1px\",\"content_border_color\":\"#ffffff\",\"content_border_radius\":\"0\",\"content_margin\":{\"xxl\":\"50px 0px 0px 0px\",\"xl\":\"50px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"40px 0px 0px 0px\",\"xs\":\"40px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"17px 40px 15px 40px\",\"xl\":\"17px 40px 15px 40px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#000000\",\"button_background_color_hover\":\"rgba(255, 255, 255, 0.59)\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"rgba(135, 135, 135, 0.7)\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"}],\"image_in_column\":0,\"image_column_width\":{\"xxl\":6,\"xl\":6,\"lg\":6,\"md\":6,\"sm\":6,\"xs\":6},\"image_column_reverse\":0,\"image_content_alignment\":\"left\",\"content_alignment\":\"right\",\"icon_display_block\":0,\"enable_youtube_vimeo\":0,\"video_volume_btn\":0,\"slider_bg_options\":\"bg_image\",\"slider_overlay_options\":\"gradient_overaly\",\"slider_bg_gradient_overlay\":{\"color\":\"rgba(255, 0, 0, 0.48)\",\"color2\":\"rgba(0, 0, 0, 0.42)\",\"deg\":\"123\",\"pos\":\"18\",\"pos2\":\"60\",\"type\":\"radial\",\"radialPos\":\"top left\"}},{\"title\":\"slide-4\",\"slider_img\":{\"src\":\"images\\/2020\\/12\\/20\\/two-muscular-bearded-tattoed-athletes-training-gym.jpg\",\"height\":1333,\"width\":2000},\"slideshow_inner_items\":[{\"title\":\"FREE WEIGHT AREA\",\"content_tabs\":\"content_type\",\"content_type\":\"title_content\",\"title_content_title\":\"FREE WEIGHT AREA\\n\\n\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"right\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"60\",\"xl\":\"60\",\"lg\":\"\",\"md\":\"\",\"sm\":\"30\",\"xs\":\"30\"},\"content_lineheight\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"10px 10px 10px 10px\",\"xl\":\"10px 10px 10px 10px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Krona One\",\"content_text_shadow\":{\"ho\":\"17\",\"vo\":0,\"blur\":\"56\",\"spread\":0,\"color\":\"#ffffff\",\"inset\":false}},{\"content_tabs\":\"content_type\",\"content_type\":\"title_content\",\"title_content_title\":\"WHAT THE TIGERS LIKE BEST\",\"content_border\":\"   \",\"content_margin\":{\"xxl\":\"0px 40px  \",\"xl\":\"0px 40px  \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_font_family\":\"Krona One\",\"content_color\":\"#ffffff\",\"title\":\"WHAT THE TIGERS LIKE BEST\",\"content_font_style\":{\"weight\":100,\"italic\":true},\"content_animation_type\":\"text-animate\",\"animation_slide_direction\":\"left\",\"content_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_text_shadow\":{\"ho\":0,\"vo\":\"5\",\"blur\":\"38\",\"spread\":0,\"color\":\"#fa0707\",\"inset\":false}},{\"title\":\"Text\",\"content_tabs\":\"content_type\",\"content_type\":\"text_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"<div style=\\\"text-align: justify;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do<\\/div>\\n<div style=\\\"text-align: justify;\\\">eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<\\/div>\\n<div style=\\\"text-align: justify;\\\">enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<\\/div>\\n<div style=\\\"text-align: justify;\\\">ut aliquip ex ea commodo consequat.<\\/div>\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"14\",\"xs\":\"14\"},\"content_lineheight\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"25px 0px 0px 0px\",\"xl\":\"25px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":false,\"weight\":400},\"content_font_family\":\"Oxygen\"},{\"title\":\"Button\",\"content_tabs\":\"content_type\",\"content_type\":\"btn_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Read More\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_lineheight\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"rgba(68, 68, 68, 0)\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"1px 1px 1px 1px\",\"content_border_color\":\"#ffffff\",\"content_border_radius\":\"0\",\"content_margin\":{\"xxl\":\"50px 0px 0px 0px\",\"xl\":\"50px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"40px 0px 0px 0px\",\"xs\":\"40px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"17px 40px 15px 40px\",\"xl\":\"17px 40px 15px 40px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#000000\",\"button_background_color_hover\":\"rgba(255, 255, 255, 0.59)\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"rgba(135, 135, 135, 0.7)\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"}],\"image_in_column\":0,\"image_column_width\":{\"xxl\":6,\"xl\":6,\"lg\":6,\"md\":6,\"sm\":6,\"xs\":6},\"image_column_reverse\":0,\"image_content_alignment\":\"left\",\"content_alignment\":\"right\",\"icon_display_block\":0,\"enable_youtube_vimeo\":0,\"video_volume_btn\":0,\"slider_bg_options\":\"bg_image\",\"slider_overlay_options\":\"gradient_overaly\",\"slider_bg_gradient_overlay\":{\"color\":\"rgba(255, 0, 0, 0.48)\",\"color2\":\"rgba(0, 0, 0, 0.42)\",\"deg\":\"123\",\"pos\":\"18\",\"pos2\":\"60\",\"type\":\"radial\",\"radialPos\":\"top left\"}},{\"title\":\"slide-5\",\"slider_img\":{\"src\":\"images\\/2020\\/12\\/19\\/muscular-sportsman-building-biceps-with-dumbbell.jpg\",\"height\":1334,\"width\":2000},\"slideshow_inner_items\":[{\"title\":\"JOIN OUR CLUB\",\"content_tabs\":\"content_type\",\"content_type\":\"title_content\",\"title_content_title\":\"JOIN OUR CLUB\\n\\n\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"right\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"60\",\"xl\":\"60\",\"lg\":\"\",\"md\":\"\",\"sm\":\"30\",\"xs\":\"30\"},\"content_lineheight\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"10px 10px 10px 10px\",\"xl\":\"10px 10px 10px 10px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Krona One\",\"content_text_shadow\":{\"ho\":\"17\",\"vo\":0,\"blur\":\"56\",\"spread\":0,\"color\":\"#ffffff\",\"inset\":false}},{\"content_tabs\":\"content_type\",\"content_type\":\"title_content\",\"title_content_title\":\"FIRST MONTH FOR FREE\",\"content_border\":\"   \",\"content_margin\":{\"xxl\":\"0px 40px  \",\"xl\":\"0px 40px  \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_font_family\":\"Krona One\",\"content_color\":\"#ffffff\",\"title\":\"FIRST MONTH FOR FREE\",\"content_font_style\":{\"weight\":100,\"italic\":true},\"content_animation_type\":\"text-animate\",\"animation_slide_direction\":\"left\",\"content_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_text_shadow\":{\"ho\":0,\"vo\":\"5\",\"blur\":\"38\",\"spread\":0,\"color\":\"#fa0707\",\"inset\":false}},{\"title\":\"Text\",\"content_tabs\":\"content_type\",\"content_type\":\"text_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"<div style=\\\"text-align: justify;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do<\\/div>\\n<div style=\\\"text-align: justify;\\\">eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<\\/div>\\n<div style=\\\"text-align: justify;\\\">enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<\\/div>\\n<div style=\\\"text-align: justify;\\\">ut aliquip ex ea commodo consequat.<\\/div>\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"14\",\"xs\":\"14\"},\"content_lineheight\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"25px 0px 0px 0px\",\"xl\":\"25px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":false,\"weight\":400},\"content_font_family\":\"Oxygen\"},{\"title\":\"Button\",\"content_tabs\":\"content_type\",\"content_type\":\"btn_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Read More\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_lineheight\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"rgba(68, 68, 68, 0)\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"1px 1px 1px 1px\",\"content_border_color\":\"#ffffff\",\"content_border_radius\":\"0\",\"content_margin\":{\"xxl\":\"50px 0px 0px 0px\",\"xl\":\"50px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"40px 0px 0px 0px\",\"xs\":\"40px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"17px 40px 15px 40px\",\"xl\":\"17px 40px 15px 40px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#000000\",\"button_background_color_hover\":\"rgba(255, 255, 255, 0.59)\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"rgba(135, 135, 135, 0.7)\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"}],\"image_in_column\":0,\"image_column_width\":{\"xxl\":6,\"xl\":6,\"lg\":6,\"md\":6,\"sm\":6,\"xs\":6},\"image_column_reverse\":0,\"image_content_alignment\":\"left\",\"content_alignment\":\"right\",\"icon_display_block\":0,\"enable_youtube_vimeo\":0,\"video_volume_btn\":0,\"slider_bg_options\":\"bg_image\",\"slider_overlay_options\":\"gradient_overaly\",\"slider_bg_gradient_overlay\":{\"color\":\"rgba(255, 0, 0, 0.48)\",\"color2\":\"rgba(0, 0, 0, 0.42)\",\"deg\":\"123\",\"pos\":\"18\",\"pos2\":\"60\",\"type\":\"radial\",\"radialPos\":\"top left\"}}],\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_use_overlay\":0,\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"0 0 20px 0\",\"md\":\"0 0 20px 0\",\"sm\":\"0 0 10px 0\",\"xs\":\"0 0 10px 0\"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"instFormId\":1606549126451,\"global_background_color\":\"#000000\",\"timer_color\":\"rgba(255, 255, 255, 0.66)\",\"slide_counter\":0,\"content_container_option\":\"bootstrap\",\"pause_on_hover\":0,\"slide_counter_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_custom_position\":1,\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"enable_tablet\":0,\"enable_mobile\":0,\"mouse_tilt_speed\":\"3\",\"mouse_tilt_max\":\"10\"}],\"timer_width\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"timer_top_gap\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"timer_left_gap\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_section_z_index\":\"1\"},\"title\":\"Slideshow\",\"icon\":\"<svg viewbox=\\\"0 0 32 32\\\" fill=\\\"none\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M17.656 10.518a1.138 1.138 0 1 0 0 2.276 1.138 1.138 0 0 0 0-2.276ZM15 11.656a2.656 2.656 0 1 1 5.312 0 2.656 2.656 0 0 1-5.312 0ZM10 27a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm12 0a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm-6.636-9.909c.885.842 1.854 1.306 2.88 1.345 1.014.038 1.939-.343 2.738-.91 1.563-1.108 2.888-3.095 3.906-5.067l-1.776-.918c-.985 1.906-2.13 3.533-3.287 4.354-.561.398-1.06.56-1.505.543-.433-.017-.96-.207-1.578-.796-1.163-1.106-2.319-1.737-3.458-1.923-1.157-.188-2.186.101-3.042.63-1.648 1.018-2.698 2.941-3.185 4.318l1.886.666c.42-1.19 1.265-2.612 2.35-3.282.511-.316 1.058-.457 1.67-.358.628.102 1.432.477 2.4 1.398Z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M9 8h14v11H9V8ZM7 8a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H9a2 2 0 0 1-2-2V8Zm-2.193 2.591A1 1 0 1 0 3.193 9.41L.236 13.444a1.246 1.246 0 0 0 0 1.46l2.703 3.687a1 1 0 1 0 1.613-1.182L2.18 14.174l2.626-3.583ZM16 27a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3ZM27.409 9.193a1 1 0 0 1 1.398.216l2.957 4.035c.315.43.315 1.03 0 1.46l-2.703 3.687a1 1 0 1 1-1.613-1.182l2.371-3.235-2.626-3.583a1 1 0 0 1 .216-1.398Z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1608457592100,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"36px 0px 56px 0px\",\"xl\":\"36px 0px 56px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#494949\",\"color2\":\"#000000\",\"deg\":\"360\",\"type\":\"linear\",\"pos\":\"0\"},\"background_image\":{\"src\":\"images\\/2020\\/12\\/25\\/brick-wall.png\",\"height\":69,\"width\":110},\"background_parallax\":0,\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(0, 0, 0, 0.8)\",\"color2\":\"rgba(255, 0, 0, 0.24)\",\"deg\":\"215\",\"type\":\"linear\",\"pos\":\"51\",\"pos2\":\"100\",\"radialPos\":\"center right\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#ffffff\",\"inset\":false,\"enabled\":false},\"show_top_shape\":0,\"shape_name\":\"turning-slope\",\"shape_color\":\"rgba(0, 0, 0, 0.19)\",\"shape_width\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"460\",\"xl\":\"460\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":0,\"show_bottom_shape\":0,\"bottom_shape_name\":\"\",\"bottom_shape_color\":\"#000000\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"600\",\"xl\":\"600\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":0,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"instFormId\":1608457592100,\"background_color\":\"#000000\",\"overlay\":\"rgba(63, 63, 63, 0.85)\",\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false},\"slider_settings\":\"slider_global\"},\"layout\":\"4,4,4\",\"columns\":[{\"id\":1608457592101,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608464373796,\"name\":\"image_overlay\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/20\\/gym3.jpg\",\"height\":800,\"width\":800},\"image_height\":300,\"background_image_animation\":\"zoom-out\",\"image_in_lightbox\":0,\"lightbox_icon_bg\":\"\",\"overlay_mode\":\"normal\",\"overlay_type\":\"gradient\",\"overlay_color\":\"rgba(0, 91, 234, 0.5)\",\"overlay_gradient\":{\"color\":\"rgba(0, 0, 0, 0.36)\",\"color2\":\"rgba(255, 0, 4, 0.16)\",\"deg\":\"190\",\"type\":\"linear\"},\"overlay_hover_type\":\"gradient\",\"overlay_hover_color\":\"\",\"overlay_hover_gradient\":{\"color\":\"rgba(0, 0, 0, 0.8)\",\"color2\":\"rgba(255, 0, 5, 0.7)\",\"deg\":\"303\",\"type\":\"linear\"},\"title\":\"Image Overlay\",\"heading_selector\":\"h4\",\"title_fontsize\":{\"xxl\":\"45\",\"xl\":\"45\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"xxl\":\"32\",\"xl\":\"32\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_link\":\"\",\"title_link_new_window\":0,\"title_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"sub_title\":\"Subtitle of the Image Overlay addon\",\"subtitle_heading_selector\":\"div\",\"sub_title_fontsize\":\"\",\"sub_title_letterspace\":\"0\",\"sub_title_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_subtitle_position\":\"center-center\",\"show_content_on_hover\":1,\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text\":\"READ MORE\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"\",\"fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"button_margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"button_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\" 0px 30px 0px\",\"xl\":\" 0px 30px 0px\",\"lg\":\"  100px \",\"md\":\"  100px \",\"sm\":\"  120px \",\"xs\":\"  120px \"},\"global_padding\":{\"xxl\":\"8px 8px 8px 8px\",\"xl\":\"8px 8px 8px 8px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":\"0\",\"spread\":\"6\",\"color\":\"rgba(70, 70, 70, 0.32)\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"200\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608464373796,\"global_addon_z_index\":\"3\",\"title_font_family\":\"Abel\",\"font_family\":\"Abel\",\"url\":\"#\",\"global_text_color\":\"#ffffff\",\"global_animation\":\"bounceInLeft\"},\"title\":\"Image Overlay\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 10.71l-9.718 5.9a5 5 0 01-5.8-.436l-3.622-3.024a3 3 0 00-3.583-.196l-6.781 4.503-1.106-1.666 6.78-4.503a5 5 0 015.971.327l3.623 3.024a3 3 0 003.48.262L30.25 9l1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27 21c0 .552-.41 1-.917 1H5.917C5.41 22 5 21.552 5 21s.41-1 .917-1h20.166c.507 0 .917.448.917 1zM16 26a1 1 0 01-1 1H6a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M28 2H4a2 2 0 00-2 2v24a2 2 0 002 2h24a2 2 0 002-2V4a2 2 0 00-2-2zM4 0a4 4 0 00-4 4v24a4 4 0 004 4h24a4 4 0 004-4V4a4 4 0 00-4-4H4z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 6a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 8.077a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608457592102,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608464373793,\"name\":\"image_overlay\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/20\\/gym2.jpg\",\"height\":800,\"width\":800},\"image_height\":300,\"background_image_animation\":\"zoom-out\",\"image_in_lightbox\":0,\"lightbox_icon_bg\":\"\",\"overlay_mode\":\"normal\",\"overlay_type\":\"gradient\",\"overlay_color\":\"rgba(0, 91, 234, 0.5)\",\"overlay_gradient\":{\"color\":\"rgba(0, 0, 0, 0.36)\",\"color2\":\"rgba(255, 0, 4, 0.16)\",\"deg\":\"190\",\"type\":\"linear\"},\"overlay_hover_type\":\"gradient\",\"overlay_hover_color\":\"\",\"overlay_hover_gradient\":{\"color\":\"rgba(0, 0, 0, 0.8)\",\"color2\":\"rgba(255, 0, 5, 0.7)\",\"deg\":\"303\",\"type\":\"linear\"},\"title\":\"Image Overlay\",\"heading_selector\":\"h4\",\"title_fontsize\":{\"xxl\":\"45\",\"xl\":\"45\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"xxl\":\"32\",\"xl\":\"32\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_link\":\"\",\"title_link_new_window\":0,\"title_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"sub_title\":\"Subtitle of the Image Overlay addon\",\"subtitle_heading_selector\":\"div\",\"sub_title_fontsize\":\"\",\"sub_title_letterspace\":\"0\",\"sub_title_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_subtitle_position\":\"center-center\",\"show_content_on_hover\":1,\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text\":\"READ MORE\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"\",\"fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"button_margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"button_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"-100px 0px 30px 0px\",\"xl\":\"-100px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"8px 8px 8px 8px\",\"xl\":\"8px 8px 8px 8px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":\"0\",\"spread\":\"6\",\"color\":\"rgba(255, 255, 255, 0.32)\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"200\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608464373793,\"global_addon_z_index\":\"3\",\"title_font_family\":\"Abel\",\"font_family\":\"Abel\",\"url\":\"#\",\"global_text_color\":\"#ffffff\",\"global_animation\":\"bounceInUp\"},\"title\":\"Image Overlay\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 10.71l-9.718 5.9a5 5 0 01-5.8-.436l-3.622-3.024a3 3 0 00-3.583-.196l-6.781 4.503-1.106-1.666 6.78-4.503a5 5 0 015.971.327l3.623 3.024a3 3 0 003.48.262L30.25 9l1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27 21c0 .552-.41 1-.917 1H5.917C5.41 22 5 21.552 5 21s.41-1 .917-1h20.166c.507 0 .917.448.917 1zM16 26a1 1 0 01-1 1H6a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M28 2H4a2 2 0 00-2 2v24a2 2 0 002 2h24a2 2 0 002-2V4a2 2 0 00-2-2zM4 0a4 4 0 00-4 4v24a4 4 0 004 4h24a4 4 0 004-4V4a4 4 0 00-4-4H4z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 6a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 8.077a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1608908722815,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"MUSIC FOR TRAINING\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-center\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":\"14\",\"spread\":0,\"color\":\"#ff0000\",\"inset\":false},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608908722815,\"title_font_family\":\"Abel\",\"global_text_color\":\"#cecece\"},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1608908761310,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Best Hip hop &amp; Trap Workout Music Mix 2020\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":{\"xxl\":\"30\",\"xl\":\"30\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_lineheight\":{\"xxl\":\"30\",\"xl\":\"30\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 20px 0px\",\"xl\":\"0px 0px 20px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608908761310,\"global_text_color\":\"#7e7e7e\",\"text_font_family\":\"Abel\"},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1608972202320,\"name\":\"modal\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"modal_selector\":\"icon\",\"button_text\":\"Button Text\",\"button_type\":\"default\",\"button_letterspace\":\"0\",\"button_padding\":\"\",\"button_appearance\":\"flat\",\"button_status\":\"normal\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color_hover\":\"#fff\",\"selector_image\":{\"src\":\"\"},\"show_ripple_effect\":1,\"selector_icon_name\":\"fas fa-play-circle\",\"selector_icon_size\":{\"xxl\":\"30\",\"xl\":\"30\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"selector_text\":\"\",\"selector_text_weight\":\"\",\"selector_text_color\":\"\",\"modal_content_type\":\"video\",\"modal_content_text\":\"Kevin chicken fatback sirloin ball tip, flank meatloaf t-bone. Meatloaf shankle swine pancetta biltong capicola ham hock meatball. Shoulder bacon andouille ground round pancetta pastrami. Sirloin beef ribs tenderloin rump corned beef filet mignon capicola kielbasa drumstick chuck turducken beef t-bone ribeye. Pork loin ground round t-bone chuck beef ribs swine pastrami cow. Venison tenderloin drumstick, filet mignon salami jowl sausage shank hamburger meatball ribeye kevin tri-tip. Swine kielbasa tenderloin fatback pork shankle andouille, flank frankfurter jerky chicken tri-tip jowl leberkas.&lt;br&gt;&lt;br&gt;Pancetta chicken pork belly beef cow kielbasa fatback sirloin biltong andouille bacon. Sirloin beef tenderloin porchetta, jerky tri-tip andouille sausage landjaeger shank bresaola short ribs tongue meatloaf fatback. Kielbasa pancetta shoulder tri-tip pastrami filet mignon ham corned beef prosciutto doner beef ribs. Doner sausage ham hock, shoulder sirloin pancetta boudin filet mignon chuck. Meatball ham hock beef, filet mignon tri-tip andouille venison ground round chuck turducken drumstick.\",\"modal_content_image\":{\"src\":\"\"},\"modal_popup_width\":\"760\",\"modal_popup_height\":\"440\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"80px 0px  0px\",\"xl\":\"80px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608972202320,\"selector_text_margin\":\"   \",\"selector_icon_border_radius\":{\"xxl\":\"20\",\"xl\":\"20\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"modal_content_video_url\":\"https:\\/\\/www.youtube.com\\/watch?v=UJPsgWq4o8o\",\"selector_icon_background\":\"#ffffff\",\"selector_icon_border_color\":\"#ffffff\",\"selector_icon_padding\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"selector_icon_border_width\":{\"xxl\":\"2\",\"xl\":\"2\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"selector_icon_color\":\"#4c0000\"},\"title\":\"Modal Popup\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M10.294 24.88l4.722 4.752c.73.49 1.663.49 2.394 0l4.721-4.752h5.616c1.138 0 2.253-1.021 2.253-2.48V4.528C29.916 3.008 28.759 2 27.641 2H4.252C3.115 2 2 3.021 2 4.48V22.4c0 1.459 1.115 2.48 2.252 2.48h6.042zM32 4.48V22.4c0 2.464-1.914 4.48-4.253 4.48h-4.784l-4.252 4.28a4.135 4.135 0 01-4.997 0l-4.252-4.28h-5.21C1.914 26.88 0 24.864 0 22.4V4.48C0 2.016 1.914 0 4.252 0h23.39C29.98 0 31.893 2.016 32 4.48z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27 10.5a1.5 1.5 0 01-1.5 1.5h-19a1.5 1.5 0 010-3h19a1.5 1.5 0 011.5 1.5zM23 16.5a1.5 1.5 0 01-1.5 1.5h-11a1.5 1.5 0 010-3h11a1.5 1.5 0 011.5 1.5z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608457592103,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608457592692,\"name\":\"image_overlay\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/20\\/gym4.jpg\",\"height\":800,\"width\":800},\"image_height\":300,\"background_image_animation\":\"zoom-out\",\"image_in_lightbox\":0,\"lightbox_icon_bg\":\"\",\"overlay_mode\":\"normal\",\"overlay_type\":\"gradient\",\"overlay_color\":\"rgba(0, 91, 234, 0.5)\",\"overlay_gradient\":{\"color\":\"rgba(0, 0, 0, 0.36)\",\"color2\":\"rgba(255, 0, 4, 0.16)\",\"deg\":\"190\",\"type\":\"linear\"},\"overlay_hover_type\":\"gradient\",\"overlay_hover_color\":\"\",\"overlay_hover_gradient\":{\"color\":\"rgba(0, 0, 0, 0.8)\",\"color2\":\"rgba(255, 0, 5, 0.7)\",\"deg\":\"303\",\"type\":\"linear\"},\"title\":\"Image Overlay\",\"heading_selector\":\"h4\",\"title_fontsize\":{\"xxl\":\"45\",\"xl\":\"45\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"xxl\":\"32\",\"xl\":\"32\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_link\":\"\",\"title_link_new_window\":0,\"title_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"sub_title\":\"Subtitle of the Image Overlay addon\",\"subtitle_heading_selector\":\"div\",\"sub_title_fontsize\":\"\",\"sub_title_letterspace\":\"0\",\"sub_title_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_subtitle_position\":\"center-center\",\"show_content_on_hover\":1,\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text\":\"READ MORE\",\"letterspace\":\"0\",\"type\":\"dark\",\"appearance\":\"\",\"fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"button_margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"button_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\" 0px 30px 0px\",\"xl\":\" 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"20px   \",\"xs\":\"20px   \"},\"global_padding\":{\"xxl\":\"8px 8px 8px 8px\",\"xl\":\"8px 8px 8px 8px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":\"0\",\"spread\":\"6\",\"color\":\"rgba(70, 70, 70, 0.32)\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"200\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608457592692,\"global_addon_z_index\":\"3\",\"title_font_family\":\"Abel\",\"font_family\":\"Abel\",\"global_text_color\":\"#ffffff\",\"global_animation\":\"bounceInRight\"},\"title\":\"Image Overlay\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 10.71l-9.718 5.9a5 5 0 01-5.8-.436l-3.622-3.024a3 3 0 00-3.583-.196l-6.781 4.503-1.106-1.666 6.78-4.503a5 5 0 015.971.327l3.623 3.024a3 3 0 003.48.262L30.25 9l1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27 21c0 .552-.41 1-.917 1H5.917C5.41 22 5 21.552 5 21s.41-1 .917-1h20.166c.507 0 .917.448.917 1zM16 26a1 1 0 01-1 1H6a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M28 2H4a2 2 0 00-2 2v24a2 2 0 002 2h24a2 2 0 002-2V4a2 2 0 00-2-2zM4 0a4 4 0 00-4 4v24a4 4 0 004 4h24a4 4 0 004-4V4a4 4 0 00-4-4H4z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 6a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 8.077a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1608970029829,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"36px 0px 50px 0px\",\"xl\":\"36px 0px 50px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"images\\/2020\\/12\\/25\\/brick-wall-dark.png\",\"height\":69,\"width\":110},\"background_parallax\":0,\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_size_custom\":{\"xxl\":\"439\",\"xl\":\"439\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"custom\",\"background_position_custom_x\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"background_position_custom_y\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(183, 0, 0, 0.82)\",\"color2\":\"rgba(67, 67, 67, 0.71)\",\"deg\":\"90\",\"type\":\"linear\",\"pos2\":\"45\",\"pos\":\"38\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"zigzag-sharp\",\"bottom_shape_color\":\"rgba(255, 255, 255, 0.17)\",\"bottom_shape_width\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"172\",\"xl\":\"172\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":0,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"instFormId\":1608970029829,\"overlay\":\"rgba(255, 255, 255, 0.88)\",\"background_color\":\"\",\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},\"layout\":\"12\",\"columns\":[{\"id\":1608970029828,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608971953396,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Diet Blog Latest News...\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"47\",\"xl\":\"47\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px   30px\",\"xl\":\"0px   30px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":{\"ho\":0,\"vo\":\"2\",\"blur\":\"0\",\"spread\":0,\"color\":\"#ffffff\",\"inset\":false},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608971953396,\"title_font_family\":\"Reenie Beanie\",\"global_text_color\":\"#3a0000\",\"title_font_style\":{\"weight\":400}},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1608970344865,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"module_type\":\"module\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 20px 0px\",\"xl\":\"0px 0px 20px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"instFormId\":1608970344865,\"id\":\"108\",\"global_margin_sm\":\"   \",\"global_margin_xs\":\"   \",\"global_custom_position\":1,\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"global_addon_z_index\":\"2\",\"global_padding_sm\":\"   \",\"global_padding_xs\":\"   \",\"global_margin_xl\":\"0px 0px 20px 0px\",\"global_margin_lg\":\"   \",\"global_margin_md\":\"   \",\"global_margin_xxl\":\"0px 0px 20px 0px\",\"global_padding_xl\":\"   \",\"global_padding_lg\":\"   \",\"global_padding_md\":\"   \",\"global_padding_xxl\":\"   \"},\"title\":\"Joomla Module\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.005 1C6.821.994 8.391 2.176 8.849 3.923c.065.25.136.315.407.218 1.234-.443 2.449-.289 3.638.212.917.386 1.712.97 2.461 1.62.117.102.13.16.013.275-.846.803-1.686 1.613-2.52 2.429-.135.135-.22.096-.348 0-.375-.27-.789-.482-1.267-.514-1.124-.077-2.255.79-2.565 1.972-.265 1.015.097 1.87.724 2.64.51.623 1.13 1.144 1.7 1.709a402.759 402.759 0 004.115 4.015c.245.238.22.353-.013.572-.808.77-1.596 1.554-2.384 2.344-.155.16-.246.2-.427.013-2.358-2.364-4.742-4.709-7.094-7.085-1.189-1.208-2.01-3.335-.943-5.236.168-.308-.11-.25-.24-.283-1-.244-1.815-.77-2.383-1.625-.885-1.336-.956-2.724-.22-4.13.66-1.285 2.01-2.063 3.502-2.069z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" d=\\\"M28.129 10.732c0 1.337-.524 2.493-1.28 3.553-.239.327-.51.63-.762.95-.116.148-.194.135-.323 0a207.68 207.68 0 00-2.352-2.415c-.155-.154-.168-.263-.039-.456.485-.707.672-1.471.24-2.261-.479-.887-1.222-1.465-2.262-1.548-1.085-.084-1.919.462-2.636 1.194-1.693 1.748-3.36 3.514-5.046 5.262-.31.32-.226.347-.581.006-.834-.803-1.66-1.612-2.5-2.409-.156-.148-.175-.238-.007-.398 2.351-2.326 4.677-4.69 7.055-6.99 1.286-1.24 3.36-1.895 5.188-.905.226.122.252.025.304-.167.413-1.632 1.44-2.666 3.095-3.039 2.203-.494 4.432 1.067 4.736 3.283.284 2.081-.912 3.88-2.966 4.445-.226.058-.24.129-.168.328.097.25.155.507.22.764.077.27.09.534.084.803zM11.13 27.936a3.725 3.725 0 01-1.861-.43c-.252-.136-.297-.046-.349.173a3.93 3.93 0 01-3.67 2.98c-1.906.052-3.514-1.04-4.044-2.755-.627-2.03.626-4.195 2.778-4.754.29-.077.317-.148.213-.418-.484-1.297-.245-2.537.394-3.726.375-.694.847-1.31 1.376-1.888.143-.154.233-.16.388-.013.788.79 1.583 1.567 2.371 2.351.09.09.149.154.052.296-.924 1.432-.53 2.723 1.04 3.43 1.163.52 2.203.186 3.108-.572.788-.662 1.499-1.407 2.235-2.12 1.183-1.15 2.365-2.3 3.54-3.456.169-.167.272-.199.46-.013.82.842 1.66 1.67 2.5 2.5.142.14.162.23 0 .378-2.41 2.236-4.8 4.49-7.23 6.713a4.933 4.933 0 01-3.301 1.324z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M27.01 31a3.803 3.803 0 01-3.682-2.884c-.084-.322-.18-.328-.465-.238-1.39.417-2.694.103-3.935-.559-.691-.373-1.305-.86-1.893-1.381-.148-.135-.18-.219-.02-.373.789-.77 1.57-1.548 2.346-2.338.162-.167.252-.135.414-.013.62.475 1.292.765 2.093.501.86-.282 1.667-1.387 1.712-2.3.045-1.021-.4-1.843-1.085-2.543-1.622-1.664-3.263-3.315-4.891-4.966-.22-.219-.575-.437-.595-.681-.02-.25.381-.443.601-.655.64-.63 1.292-1.253 1.932-1.89.149-.153.233-.14.375.007 2.274 2.326 4.574 4.638 6.829 6.977 1.221 1.265 1.893 3.417.93 5.203-.122.225-.013.264.168.308 1.628.424 2.598 1.478 2.946 3.09.524 2.429-1.35 4.754-3.78 4.735z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1608979335898,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images\\/2020\\/12\\/26\\/happy-brunette-fitness-woman-with-towel-holding-arm-hip-removebg-preview.png\",\"height\":535,\"width\":467},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xxl\":\"-395\",\"xl\":\"-395\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xxl\":\"199\",\"xl\":\"199\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":1,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608979335898,\"global_addon_z_index\":\"1\",\"global_animation\":\"fadeIn\"},\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1608838531206,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"42px 0px 40px 0px\",\"xl\":\"42px 0px 40px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#000000\",\"color2\":\"#4a4a4a\",\"deg\":\"136\",\"type\":\"linear\",\"pos2\":\"100\",\"pos\":\"0\"},\"background_image\":{\"src\":\"images\\/2020\\/12\\/20\\/brunette-athletic-young-girl-working-out-gym.jpg\",\"height\":1331,\"width\":2000},\"background_parallax\":1,\"background_repeat\":\"no-repeat\",\"background_size\":\"inherit\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"50% 50%\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_gradient\",\"gradient_overlay\":{\"color\":\"#000000\",\"color2\":\"rgba(0, 0, 0, 0.89)\",\"deg\":\"360\",\"type\":\"linear\",\"pos2\":\"94\",\"pos\":\"0\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":1,\"shape_name\":\"slope\",\"shape_color\":\"\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"21\",\"xl\":\"21\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":0,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"instFormId\":1608838531206,\"overlay\":\"rgba(255, 255, 255, 0.79)\",\"background_color\":\"#111111\",\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},\"layout\":\"12\",\"columns\":[{\"id\":1608838531205,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608841395193,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Timetable for the whole week\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"32\",\"xl\":\"32\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-center\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608841395193,\"title_font_family\":\"Abel\",\"global_text_color\":\"#f5f5f5\"},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":\"hCJyQ7C4wq21E1Lax_Cx0\",\"name\":\"tab\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"custom\",\"sp_tab_item\":[{\"title\":\"Monday\",\"subtitle\":\" \",\"image_or_icon\":\"icon\",\"icon\":\"\",\"image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"6BIjpkNQ3oB-ZRnhj6zkj\",\"name\":\"row\"}]},{\"title\":\"Tuesday\",\"subtitle\":\" \",\"image_or_icon\":\"icon\",\"icon\":\"\",\"image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"6Un3B3QLeM-FrgX1YVUQ3\",\"name\":\"row\"}]},{\"title\":\"Wednesday\",\"subtitle\":\" \",\"image_or_icon\":\"icon\",\"icon\":\"\",\"image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"ojBwNGZTZaTwbnxKJFZ41\",\"name\":\"row\"}]},{\"title\":\"Thursday\",\"subtitle\":\" \",\"image_or_icon\":\"icon\",\"icon\":\"\",\"image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"aqyGOTFiAENekdP9kVNCY\",\"name\":\"row\"}]},{\"title\":\"Friday\",\"subtitle\":\" \",\"image_or_icon\":\"icon\",\"icon\":\"\",\"image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"4TltdptXx1oz0AlzDyWhe\",\"name\":\"row\"}]},{\"title\":\"Saturday\",\"subtitle\":\" \",\"image_or_icon\":\"icon\",\"icon\":\"\",\"image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"GBoD0SIWklQOderT_Xt_d\",\"name\":\"row\"}]},{\"title\":\"Sunday\",\"image_or_icon\":\"icon\",\"icon\":\"\",\"image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"Avq4oiTJL67CN18dHdrw4\",\"name\":\"row\"}]}],\"custom_tab_style\":\"navigation\",\"nav_gutter\":{\"xxl\":\"19\",\"xl\":\"19\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"nav_style\":\"active\",\"nav_width\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":30,\"md\":30,\"sm\":30,\"xs\":30},\"nav_color\":\"rgba(176, 173, 173, 0.83)\",\"nav_bg_color\":\"rgba(53, 52, 52, 0.26)\",\"nav_fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"nav_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"nav_border\":\"1px 1px 1px 1px\",\"nav_border_color\":\"#292929\",\"nav_border_radius\":\"\",\"nav_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"nav_padding\":{\"xxl\":\"10px 10px 10px 10px\",\"xl\":\"10px 10px 10px 10px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"nav_text_align\":\"left\",\"hover_tab_bg\":\"rgba(59, 56, 56, 0.63)\",\"hover_tab_color\":\"\",\"hover_tab_border_width\":\"   \",\"hover_tab_border_color\":\"#b9b9b9\",\"active_tab_bg\":\"rgba(42, 42, 42, 0.35)\",\"active_tab_color\":\"#dd9400\",\"active_tab_border_width\":\"   \",\"active_tab_border_color\":\"#444444\",\"image_or_icon_style\":\"icon_style\",\"nav_icon_postion\":\"right\",\"icon_fontsize\":{\"xxl\":\"13\",\"xl\":\"13\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"nav_image_postion\":\"left\",\"image_height\":{\"xxl\":30,\"xl\":30,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_width\":{\"xxl\":30,\"xl\":30,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_color\":\"#ffab00\",\"content_backround\":\"\",\"content_fontsize\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_lineheight\":{\"xxl\":\"5\",\"xl\":\"5\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_border\":\"0\",\"content_border_radius\":\"0\",\"content_border_color\":\"\",\"show_boxshadow\":0,\"shadow_color\":\"\",\"shadow_horizontal\":\"\",\"shadow_vertical\":\"\",\"shadow_blur\":\"\",\"shadow_spread\":\"0\",\"content_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"xxl\":\"10px 10px 10px 10px\",\"xl\":\"10px 10px 10px 10px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":1,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608838935973,\"nav_position\":\"nav-left\",\"nav_font_family\":\"Abel\"},\"title\":\"Tabs\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M30 2.6H2a.4.4 0 00-.4.4v3c0 .22.18.4.4.4h28a.4.4 0 00.4-.4V3a.4.4 0 00-.4-.4zM2 1a2 2 0 00-2 2v3a2 2 0 002 2h28a2 2 0 002-2V3a2 2 0 00-2-2H2z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M7.6 8.6v20.8h17.8V8.6H7.6zM7 7a1 1 0 00-1 1v22a1 1 0 001 1h19a1 1 0 001-1V8a1 1 0 00-1-1H7z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M22 14a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1zM22 19a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1zM17 24a1 1 0 01-1 1h-4a1 1 0 110-2h4a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M11 2a1 1 0 011-1h9a1 1 0 011 1v6H11V2z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1608915756865,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"40px 0px 66px 0px\",\"xl\":\"40px 0px 66px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\" 0px 0px 0px\",\"xl\":\" 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"images\\/2020\\/12\\/25\\/brick-wall-dark.png\",\"height\":69,\"width\":110},\"background_parallax\":0,\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(0, 0, 0, 0.48)\",\"color2\":\"rgba(255, 0, 3, 0.57)\",\"deg\":\"306\",\"type\":\"linear\",\"pos2\":\"100\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"instFormId\":1608915756865,\"background_color\":\"#bcbcbc\",\"overlay\":\"rgba(11, 11, 11, 0.83)\",\"fit_columns\":{\"xxl\":false,\"xl\":false,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false}},\"layout\":\"12,4,4,4\",\"columns\":[{\"id\":1608915756864,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1608915756864},\"addons\":[{\"id\":1609014659210,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Pricing Plan\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"47\",\"xl\":\"47\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px   30px\",\"xl\":\"0px   30px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":{\"ho\":0,\"vo\":\"2\",\"blur\":\"0\",\"spread\":0,\"color\":\"#000000\",\"inset\":false},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":\"0\",\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#ffffff\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1609014659210,\"title_font_family\":\"Reenie Beanie\",\"global_text_color\":\"#ff7200\",\"title_font_style\":{\"weight\":400}},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608915756866,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608915757215,\"name\":\"pricing\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"FREE\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"xxl\":\"40\",\"xl\":\"40\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"xxl\":24,\"xl\":24,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#ffffff\",\"title_margin_top\":{\"xxl\":0,\"xl\":0,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"xxl\":20,\"xl\":20,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price\":\"$00,00\",\"price_color\":\"#ff4e00\",\"price_font_size\":{\"xxl\":36,\"xl\":36,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price_symbol\":\"\",\"price_symbol_alignment\":\"\",\"price_symbol_color\":\"\",\"price_symbol_font_size\":\"\",\"duration\":\"\",\"duration_color\":\"\",\"duration_font_size\":\"\",\"price_position\":\"after\",\"price_margin_bottom\":{\"xxl\":30,\"xl\":30,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price_padding_bottom\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content\":\"Free WIFI\\n1 hour free\\nProtein cocktail -50%\\nFree body composition measurement\\nFree consultation with a trainer\",\"pricing_content_font_size\":{\"xxl\":\"17\",\"xl\":\"17\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_gap\":{\"xxl\":20,\"xl\":20,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_margin_bottom\":{\"xxl\":40,\"xl\":40,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_text\":\"Proceed\",\"button_letterspace\":\"0\",\"button_type\":\"custom\",\"button_appearance\":\"outline\",\"button_status\":\"normal\",\"button_background_color\":\"#ffffff\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color\":\"#ffffff\",\"button_background_color_hover\":\"#ffffff\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color_hover\":\"#7d7d7d\",\"alignment\":\"sppb-text-center\",\"pricing_hover_scale\":1,\"pricing_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"30px 30px 30px 30px\",\"xl\":\"30px 30px 30px 30px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":1,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"1\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608915757215,\"button_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_family\":\"Abel\",\"global_background_color\":\"#111111\",\"pricing_content_font_family\":\"Abel\",\"price_font_family\":\"Abel\",\"global_text_color\":\"#dddddd\",\"button_url\":\"#button1 link\"},\"title\":\"Pricing Table\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M.15 9A2.85 2.85 0 013 6.15h5v1.7H3A1.15 1.15 0 001.85 9v14c0 .635.515 1.15 1.15 1.15h5v1.7H3A2.85 2.85 0 01.15 23V9zM31.85 23A2.85 2.85 0 0129 25.85h-5v-1.7h5A1.15 1.15 0 0030.15 23V9A1.15 1.15 0 0029 7.85h-5v-1.7h5A2.85 2.85 0 0131.85 9v14z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M23 1.707H9c-.22 0-.4.19-.4.426v27.734c0 .235.18.426.4.426h14c.22 0 .4-.19.4-.426V2.133c0-.235-.18-.426-.4-.426zM9 0C7.895 0 7 .955 7 2.133v27.734C7 31.045 7.895 32 9 32h14c1.105 0 2-.955 2-2.133V2.133C25 .955 24.105 0 23 0H9z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M18.24 11.04c0 .587-.187 1.063-.56 1.43-.373.36-.86.577-1.46.65V14h-.67v-.87c-.56-.04-1.04-.197-1.44-.47a2.264 2.264 0 01-.86-1.11l1.19-.69c.213.533.583.837 1.11.91v-1.73h-.01l-.02-.01a8.986 8.986 0 01-.57-.23 4.433 4.433 0 01-.52-.29 2.134 2.134 0 01-.46-.39 2.306 2.306 0 01-.29-.53 1.979 1.979 0 01-.12-.7c0-.587.19-1.057.57-1.41.387-.353.86-.557 1.42-.61V5h.67v.89c.907.107 1.547.577 1.92 1.41l-1.16.68c-.16-.4-.413-.643-.76-.73v1.67c.62.247 1.037.443 1.25.59.513.367.77.877.77 1.53zM14.93 7.9c0 .147.047.277.14.39.093.107.253.217.48.33v-1.4c-.2.04-.353.12-.46.24a.639.639 0 00-.16.44zm1.29 3.85c.427-.093.64-.327.64-.7a.59.59 0 00-.16-.42c-.1-.113-.26-.22-.48-.32v1.44z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M21 16.5a.5.5 0 01-.5.5h-9a.5.5 0 010-1h9a.5.5 0 01.5.5zM19 18.5a.5.5 0 01-.5.5h-5a.5.5 0 010-1h5a.5.5 0 01.5.5z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"11\\\" y=\\\"24\\\" width=\\\"10\\\" height=\\\"3\\\" rx=\\\"1.5\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608915756867,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608915858088,\"name\":\"pricing\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"PERSONAL\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"xxl\":\"40\",\"xl\":\"40\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"xxl\":24,\"xl\":24,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#ffffff\",\"title_margin_top\":{\"xxl\":0,\"xl\":0,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"xxl\":20,\"xl\":20,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price\":\"$49.99\",\"price_color\":\"#000000\",\"price_font_size\":{\"xxl\":36,\"xl\":36,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price_symbol\":\"\",\"price_symbol_alignment\":\"\",\"price_symbol_color\":\"\",\"price_symbol_font_size\":\"\",\"duration\":\"\",\"duration_color\":\"\",\"duration_font_size\":\"\",\"price_position\":\"after\",\"price_margin_bottom\":{\"xxl\":30,\"xl\":30,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price_padding_bottom\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content\":\"Free WIFI\\n1 hour free\\nProtein cocktail -50%\\nFree body composition measurement\\nFree consultation with a trainer\",\"pricing_content_font_size\":{\"xxl\":\"17\",\"xl\":\"17\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_gap\":{\"xxl\":20,\"xl\":20,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_margin_bottom\":{\"xxl\":40,\"xl\":40,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_text\":\"Proceed\",\"button_letterspace\":\"0\",\"button_type\":\"custom\",\"button_appearance\":\"outline\",\"button_status\":\"normal\",\"button_background_color\":\"#ffffff\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color\":\"#ffffff\",\"button_background_color_hover\":\"#ffffff\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color_hover\":\"#7d7d7d\",\"alignment\":\"sppb-text-center\",\"pricing_hover_scale\":1,\"pricing_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"30px 30px 30px 30px\",\"xl\":\"30px 30px 30px 30px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":\"6\",\"spread\":\"9\",\"color\":\"#181818\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":1,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"1\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608915858088,\"button_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_family\":\"Abel\",\"global_background_color\":\"#ff6200\",\"pricing_content_font_family\":\"Abel\",\"price_font_family\":\"Abel\",\"global_text_color\":\"#dddddd\",\"global_width\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_url\":\"#button2 link\",\"global_animation\":\"bounceIn\"},\"title\":\"Pricing Table\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M.15 9A2.85 2.85 0 013 6.15h5v1.7H3A1.15 1.15 0 001.85 9v14c0 .635.515 1.15 1.15 1.15h5v1.7H3A2.85 2.85 0 01.15 23V9zM31.85 23A2.85 2.85 0 0129 25.85h-5v-1.7h5A1.15 1.15 0 0030.15 23V9A1.15 1.15 0 0029 7.85h-5v-1.7h5A2.85 2.85 0 0131.85 9v14z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M23 1.707H9c-.22 0-.4.19-.4.426v27.734c0 .235.18.426.4.426h14c.22 0 .4-.19.4-.426V2.133c0-.235-.18-.426-.4-.426zM9 0C7.895 0 7 .955 7 2.133v27.734C7 31.045 7.895 32 9 32h14c1.105 0 2-.955 2-2.133V2.133C25 .955 24.105 0 23 0H9z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M18.24 11.04c0 .587-.187 1.063-.56 1.43-.373.36-.86.577-1.46.65V14h-.67v-.87c-.56-.04-1.04-.197-1.44-.47a2.264 2.264 0 01-.86-1.11l1.19-.69c.213.533.583.837 1.11.91v-1.73h-.01l-.02-.01a8.986 8.986 0 01-.57-.23 4.433 4.433 0 01-.52-.29 2.134 2.134 0 01-.46-.39 2.306 2.306 0 01-.29-.53 1.979 1.979 0 01-.12-.7c0-.587.19-1.057.57-1.41.387-.353.86-.557 1.42-.61V5h.67v.89c.907.107 1.547.577 1.92 1.41l-1.16.68c-.16-.4-.413-.643-.76-.73v1.67c.62.247 1.037.443 1.25.59.513.367.77.877.77 1.53zM14.93 7.9c0 .147.047.277.14.39.093.107.253.217.48.33v-1.4c-.2.04-.353.12-.46.24a.639.639 0 00-.16.44zm1.29 3.85c.427-.093.64-.327.64-.7a.59.59 0 00-.16-.42c-.1-.113-.26-.22-.48-.32v1.44z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M21 16.5a.5.5 0 01-.5.5h-9a.5.5 0 010-1h9a.5.5 0 01.5.5zM19 18.5a.5.5 0 01-.5.5h-5a.5.5 0 010-1h5a.5.5 0 01.5.5z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"11\\\" y=\\\"24\\\" width=\\\"10\\\" height=\\\"3\\\" rx=\\\"1.5\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608915757362,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608915757218,\"name\":\"pricing\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"PROFESSIONAL\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"xxl\":\"40\",\"xl\":\"40\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"xxl\":24,\"xl\":24,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#ffffff\",\"title_margin_top\":{\"xxl\":0,\"xl\":0,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"xxl\":20,\"xl\":20,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price\":\"$70.99\",\"price_color\":\"#ff4e00\",\"price_font_size\":{\"xxl\":36,\"xl\":36,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price_symbol\":\"\",\"price_symbol_alignment\":\"\",\"price_symbol_color\":\"\",\"price_symbol_font_size\":\"\",\"duration\":\"\",\"duration_color\":\"\",\"duration_font_size\":\"\",\"price_position\":\"after\",\"price_margin_bottom\":{\"xxl\":30,\"xl\":30,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price_padding_bottom\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content\":\"Free WIFI\\n1 hour free\\nProtein cocktail -50%\\nFree body composition measurement\\nFree consultation with a trainer\",\"pricing_content_font_size\":{\"xxl\":\"17\",\"xl\":\"17\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_gap\":{\"xxl\":20,\"xl\":20,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_margin_bottom\":{\"xxl\":40,\"xl\":40,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_text\":\"Proceed\",\"button_letterspace\":\"0\",\"button_type\":\"custom\",\"button_appearance\":\"outline\",\"button_status\":\"normal\",\"button_background_color\":\"#ffffff\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color\":\"#ffffff\",\"button_background_color_hover\":\"#ffffff\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color_hover\":\"#7d7d7d\",\"alignment\":\"sppb-text-center\",\"pricing_hover_scale\":1,\"pricing_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"30px 30px 30px 30px\",\"xl\":\"30px 30px 30px 30px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":1,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"1\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608915757218,\"button_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_family\":\"Abel\",\"global_background_color\":\"#111111\",\"pricing_content_font_family\":\"Abel\",\"price_font_family\":\"Abel\",\"global_text_color\":\"#dddddd\",\"button_url\":\"#button3 link\"},\"title\":\"Pricing Table\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M.15 9A2.85 2.85 0 013 6.15h5v1.7H3A1.15 1.15 0 001.85 9v14c0 .635.515 1.15 1.15 1.15h5v1.7H3A2.85 2.85 0 01.15 23V9zM31.85 23A2.85 2.85 0 0129 25.85h-5v-1.7h5A1.15 1.15 0 0030.15 23V9A1.15 1.15 0 0029 7.85h-5v-1.7h5A2.85 2.85 0 0131.85 9v14z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M23 1.707H9c-.22 0-.4.19-.4.426v27.734c0 .235.18.426.4.426h14c.22 0 .4-.19.4-.426V2.133c0-.235-.18-.426-.4-.426zM9 0C7.895 0 7 .955 7 2.133v27.734C7 31.045 7.895 32 9 32h14c1.105 0 2-.955 2-2.133V2.133C25 .955 24.105 0 23 0H9z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M18.24 11.04c0 .587-.187 1.063-.56 1.43-.373.36-.86.577-1.46.65V14h-.67v-.87c-.56-.04-1.04-.197-1.44-.47a2.264 2.264 0 01-.86-1.11l1.19-.69c.213.533.583.837 1.11.91v-1.73h-.01l-.02-.01a8.986 8.986 0 01-.57-.23 4.433 4.433 0 01-.52-.29 2.134 2.134 0 01-.46-.39 2.306 2.306 0 01-.29-.53 1.979 1.979 0 01-.12-.7c0-.587.19-1.057.57-1.41.387-.353.86-.557 1.42-.61V5h.67v.89c.907.107 1.547.577 1.92 1.41l-1.16.68c-.16-.4-.413-.643-.76-.73v1.67c.62.247 1.037.443 1.25.59.513.367.77.877.77 1.53zM14.93 7.9c0 .147.047.277.14.39.093.107.253.217.48.33v-1.4c-.2.04-.353.12-.46.24a.639.639 0 00-.16.44zm1.29 3.85c.427-.093.64-.327.64-.7a.59.59 0 00-.16-.42c-.1-.113-.26-.22-.48-.32v1.44z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M21 16.5a.5.5 0 01-.5.5h-9a.5.5 0 010-1h9a.5.5 0 01.5.5zM19 18.5a.5.5 0 01-.5.5h-5a.5.5 0 010-1h5a.5.5 0 01.5.5z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"11\\\" y=\\\"24\\\" width=\\\"10\\\" height=\\\"3\\\" rx=\\\"1.5\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1608919409140,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/fit5.png\",\"height\":323,\"width\":506},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xxl\":\"-528\",\"xl\":\"-528\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xxl\":\"282\",\"xl\":\"282\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608919409140,\"global_width\":{\"xxl\":\"82\",\"xl\":\"82\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_addon_z_index\":\"2\"},\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1608960040525,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"74px 0px 22px 0px\",\"xl\":\"74px 0px 22px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#ffffff\",\"color2\":\"#3f3f3f\",\"deg\":\"281\",\"type\":\"linear\",\"pos2\":\"100\"},\"background_image\":{\"src\":\"images\\/2020\\/12\\/25\\/brick-wall-dark.png\",\"height\":69,\"width\":110},\"background_parallax\":0,\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_size_custom\":{\"xxl\":\"1050\",\"xl\":\"1050\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"xxl\":\"-16\",\"xl\":\"-16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"background_position_custom_y\":{\"xxl\":\"1\",\"xl\":\"1\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_gradient\",\"gradient_overlay\":{\"color\":\"#383838\",\"color2\":\"rgba(131, 131, 131, 0.88)\",\"deg\":\"270\",\"type\":\"linear\",\"pos2\":\"34\",\"pos\":\"61\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"turning-slope\",\"bottom_shape_color\":\"rgba(255, 255, 255, 0.24)\",\"bottom_shape_width\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"94\",\"xl\":\"94\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":1,\"bottom_shape_invert\":1,\"bottom_shape_to_front\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"instFormId\":1608960040525,\"background_color\":\"#ffffff\",\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false}},\"layout\":\"6,6\",\"columns\":[{\"id\":1608960040524,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608960218811,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"module_type\":\"module\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0px 0px 0px 0px \",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"instFormId\":1608960218811,\"id\":\"107\",\"global_margin_sm\":\"   \",\"global_margin_xs\":\"   \",\"global_padding_sm\":\"   \",\"global_padding_xs\":\"   \",\"global_text_color\":\"#ffffff\",\"global_margin_xl\":\"0px 0px 30px 0px\",\"global_margin_lg\":\"   \",\"global_margin_md\":\"   \",\"global_margin_xxl\":\"0px 0px 30px 0px\",\"global_padding_xl\":\"   \",\"global_padding_lg\":\"   \",\"global_padding_md\":\"   \",\"global_padding_xxl\":\"   \"},\"title\":\"Joomla Module\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.005 1C6.821.994 8.391 2.176 8.849 3.923c.065.25.136.315.407.218 1.234-.443 2.449-.289 3.638.212.917.386 1.712.97 2.461 1.62.117.102.13.16.013.275-.846.803-1.686 1.613-2.52 2.429-.135.135-.22.096-.348 0-.375-.27-.789-.482-1.267-.514-1.124-.077-2.255.79-2.565 1.972-.265 1.015.097 1.87.724 2.64.51.623 1.13 1.144 1.7 1.709a402.759 402.759 0 004.115 4.015c.245.238.22.353-.013.572-.808.77-1.596 1.554-2.384 2.344-.155.16-.246.2-.427.013-2.358-2.364-4.742-4.709-7.094-7.085-1.189-1.208-2.01-3.335-.943-5.236.168-.308-.11-.25-.24-.283-1-.244-1.815-.77-2.383-1.625-.885-1.336-.956-2.724-.22-4.13.66-1.285 2.01-2.063 3.502-2.069z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" d=\\\"M28.129 10.732c0 1.337-.524 2.493-1.28 3.553-.239.327-.51.63-.762.95-.116.148-.194.135-.323 0a207.68 207.68 0 00-2.352-2.415c-.155-.154-.168-.263-.039-.456.485-.707.672-1.471.24-2.261-.479-.887-1.222-1.465-2.262-1.548-1.085-.084-1.919.462-2.636 1.194-1.693 1.748-3.36 3.514-5.046 5.262-.31.32-.226.347-.581.006-.834-.803-1.66-1.612-2.5-2.409-.156-.148-.175-.238-.007-.398 2.351-2.326 4.677-4.69 7.055-6.99 1.286-1.24 3.36-1.895 5.188-.905.226.122.252.025.304-.167.413-1.632 1.44-2.666 3.095-3.039 2.203-.494 4.432 1.067 4.736 3.283.284 2.081-.912 3.88-2.966 4.445-.226.058-.24.129-.168.328.097.25.155.507.22.764.077.27.09.534.084.803zM11.13 27.936a3.725 3.725 0 01-1.861-.43c-.252-.136-.297-.046-.349.173a3.93 3.93 0 01-3.67 2.98c-1.906.052-3.514-1.04-4.044-2.755-.627-2.03.626-4.195 2.778-4.754.29-.077.317-.148.213-.418-.484-1.297-.245-2.537.394-3.726.375-.694.847-1.31 1.376-1.888.143-.154.233-.16.388-.013.788.79 1.583 1.567 2.371 2.351.09.09.149.154.052.296-.924 1.432-.53 2.723 1.04 3.43 1.163.52 2.203.186 3.108-.572.788-.662 1.499-1.407 2.235-2.12 1.183-1.15 2.365-2.3 3.54-3.456.169-.167.272-.199.46-.013.82.842 1.66 1.67 2.5 2.5.142.14.162.23 0 .378-2.41 2.236-4.8 4.49-7.23 6.713a4.933 4.933 0 01-3.301 1.324z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M27.01 31a3.803 3.803 0 01-3.682-2.884c-.084-.322-.18-.328-.465-.238-1.39.417-2.694.103-3.935-.559-.691-.373-1.305-.86-1.893-1.381-.148-.135-.18-.219-.02-.373.789-.77 1.57-1.548 2.346-2.338.162-.167.252-.135.414-.013.62.475 1.292.765 2.093.501.86-.282 1.667-1.387 1.712-2.3.045-1.021-.4-1.843-1.085-2.543-1.622-1.664-3.263-3.315-4.891-4.966-.22-.219-.575-.437-.595-.681-.02-.25.381-.443.601-.655.64-.63 1.292-1.253 1.932-1.89.149-.153.233-.14.375.007 2.274 2.326 4.574 4.638 6.829 6.977 1.221 1.265 1.893 3.417.93 5.203-.122.225-.013.264.168.308 1.628.424 2.598 1.478 2.946 3.09.524 2.429-1.35 4.754-3.78 4.735z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608960040532,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"type\":\"nested_row\",\"name\":\"row\",\"id\":1608960040551,\"title\":\"Row\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M3 28.857h26v-8.571H3v8.571zM1 29.93C1 30.52 1.448 31 2 31h28c.552 0 1-.48 1-1.071V19.214c0-.591-.448-1.071-1-1.071H2c-.552 0-1 .48-1 1.071V29.93zM3 11.714h26V3.143H3v8.571zm-2 1.072c0 .591.448 1.071 1 1.071h28c.552 0 1-.48 1-1.071V2.07C31 1.48 30.552 1 30 1H2c-.552 0-1 .48-1 1.071v10.715z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1608468526907,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"72px 0px 64px 0px\",\"xl\":\"72px 0px 64px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#757575\",\"color2\":\"#5b5b5b\",\"deg\":\"309\",\"type\":\"linear\",\"pos\":\"71\",\"pos2\":\"39\"},\"background_image\":{\"src\":\"images\\/2020\\/12\\/25\\/black-orchid.png\",\"height\":300,\"width\":300},\"background_parallax\":0,\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"50% 50%\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_gradient\",\"gradient_overlay\":{\"color\":\"rgba(255, 255, 255, 0.12)\",\"color2\":\"rgba(0, 3, 12, 0)\",\"deg\":\"172\",\"type\":\"linear\",\"pos\":\"0\",\"pos2\":\"45\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"slope\",\"shape_color\":\"#848484\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":0,\"show_bottom_shape\":0,\"bottom_shape_name\":\"turning-slope\",\"bottom_shape_color\":\"rgba(0, 0, 0, 0.11)\",\"bottom_shape_width\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"597\",\"xl\":\"597\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":0,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"instFormId\":1608468526907,\"background_color\":\"#000000\",\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false}},\"layout\":\"6,6\",\"columns\":[{\"id\":1608468526905,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608469063847,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images\\/2020\\/12\\/20\\/young-beautiful-woman-training-gym-concept-fitness-workout-sport-health.jpg\",\"height\":532,\"width\":800},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"xxl\":\"4\",\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_border_radius\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xxl\":\"5px 5px 5px 5px\",\"xl\":\"5px 5px 5px 5px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":\"18\",\"vo\":\"14\",\"blur\":\"20\",\"spread\":0,\"color\":\"#000000\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"600\",\"global_animationdelay\":\"200\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608469063847,\"global_addon_z_index\":\"2\",\"global_background_color\":\"#ffffff\",\"global_boder_style\":\"solid\",\"global_border_color\":\"#ffffff\",\"image_width\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_animation\":\"fadeInLeft\"},\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1608913593671,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/zakonczenie-portret-mlody-afroamerican-bokser-pokazuje-jego-piesci_171337-8290.jpg\",\"height\":417,\"width\":626},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"xxl\":\"3\",\"xl\":\"3\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":\"14\",\"spread\":\"3\",\"color\":\"#000000\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xxl\":\"-75\",\"xl\":\"-75\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xxl\":\"210\",\"xl\":\"210\",\"lg\":\"\",\"md\":\"\",\"sm\":\"150\",\"xs\":\"150\",\"unit\":\"px\"},\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608913593671,\"global_width\":{\"xxl\":\"57\",\"xl\":\"57\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_section_z_index\":\"\",\"global_addon_z_index\":\"3\",\"global_border_color\":\"#ffffff\",\"global_boder_style\":\"solid\",\"global_animation\":\"fadeInRight\"},\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608468526906,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608472292812,\"name\":\"carouselpro\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"carousel_height\":{\"xxl\":\"429\",\"xl\":\"429\",\"lg\":\"\",\"md\":\"\",\"sm\":\"181\",\"xs\":\"181\"},\"autoplay\":1,\"interval\":5,\"speed\":600,\"controllers\":0,\"arrows\":1,\"arrow_position\":\"bottom-right\",\"arrow_icon\":\"angle\",\"arrow_style\":\"normal_arrow\",\"arrow_height\":\"25\",\"arrow_width\":\"54\",\"arrow_background\":\"\",\"arrow_color\":\"rgba(202, 202, 202, 0.08)\",\"arrow_font_size\":\"17\",\"arrow_border_width\":\"1\",\"arrow_border_color\":\"#222222\",\"arrow_border_radius\":\"\",\"arrow_margin\":\"2px 2px 2px 2px\",\"arrow_hover_background\":\"rgba(54, 54, 54, 0.37)\",\"arrow_hover_color\":\"#c6c6c6\",\"arrow_hover_border_color\":\"\",\"sp_carouselpro_item\":[{\"title\":\"Full-Body Strength\",\"title_color\":\"#ffffff\",\"title_fontsize\":{\"md\":\"34\",\"sm\":36,\"xs\":16},\"title_lineheight\":{\"md\":\"60\",\"sm\":46,\"xs\":20},\"title_letterspace\":\"\",\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.\",\"content_fontsize\":{\"md\":\"20\",\"sm\":14,\"xs\":12},\"content_lineheight\":{\"md\":\"26\",\"sm\":22,\"xs\":16},\"content_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"bg\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"button_text\":\"Read More\",\"button_type\":\"default\",\"fontsize\":{\"md\":16},\"button_letterspace\":\"0\",\"button_appearance\":\"outline\",\"button_status\":\"normal\",\"button_background_color\":\"rgba(0, 0, 0, 0.59)\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color\":\"#fff\",\"button_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color_hover\":\"#fff\",\"content_font_family\":\"Abel\",\"button_shape\":\"square\",\"title_font_family\":\"Abel\",\"button_size\":\"sm\"},{\"title\":\"Lean Machines\",\"title_color\":\"#ffffff\",\"title_fontsize\":{\"md\":\"34\",\"sm\":36,\"xs\":16},\"title_lineheight\":{\"md\":\"60\",\"sm\":46,\"xs\":20},\"title_letterspace\":\"\",\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam\",\"content_fontsize\":{\"md\":\"20\",\"sm\":14,\"xs\":12},\"content_lineheight\":{\"md\":\"26\",\"sm\":22,\"xs\":16},\"content_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"bg\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"button_text\":\"Read More\",\"button_type\":\"default\",\"fontsize\":{\"md\":16},\"button_letterspace\":\"0\",\"button_appearance\":\"outline\",\"button_status\":\"normal\",\"button_background_color\":\"rgba(0, 0, 0, 0.59)\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color\":\"#fff\",\"button_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color_hover\":\"#fff\",\"content_font_family\":\"Abel\",\"button_shape\":\"square\",\"title_font_family\":\"Abel\",\"button_size\":\"sm\"},{\"title\":\"Power Yoga\",\"title_color\":\"#ffffff\",\"title_fontsize\":{\"md\":\"34\",\"sm\":36,\"xs\":16},\"title_lineheight\":{\"md\":\"60\",\"sm\":46,\"xs\":20},\"title_letterspace\":\"\",\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.\",\"content_fontsize\":{\"md\":\"20\",\"sm\":14,\"xs\":12},\"content_lineheight\":{\"md\":\"26\",\"sm\":22,\"xs\":16},\"content_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"bg\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"button_text\":\"Read More\",\"button_type\":\"default\",\"fontsize\":{\"md\":16},\"button_letterspace\":\"0\",\"button_appearance\":\"outline\",\"button_status\":\"normal\",\"button_background_color\":\"rgba(0, 0, 0, 0.59)\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color\":\"#fff\",\"button_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color_hover\":\"#fff\",\"content_font_family\":\"Abel\",\"button_shape\":\"square\",\"title_font_family\":\"Abel\",\"button_size\":\"sm\"}],\"full_container\":1,\"item_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"600\",\"global_animationdelay\":\"200\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608472292812,\"content_column\":\"12\",\"global_text_color\":\"#afafaf\",\"global_addon_z_index\":\"1\",\"global_animation\":\"fadeInRight\"},\"title\":\"Carousel Pro\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M27.9 19.5v-6.9c0-.5.5-.7.8-.4l3.1 3.5c.2.2.2.6 0 .8L28.7 20c-.3.2-.8-.1-.8-.5zM4.2 12.5v6.9c0 .5-.5.7-.8.4L.3 16.3c-.2-.2-.2-.6 0-.8L3.4 12c.3-.2.8.1.8.5z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M23 5H9v22h14V5zM9 3c-1.1 0-2 .9-2 2v22c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2H9z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M21 21c0 .6-.4 1-1 1h-8c-.6 0-1-.4-1-1s.4-1 1-1h8c.6 0 1 .4 1 1zM17 24c0 .6-.4 1-1 1h-4c-.6 0-1-.4-1-1s.4-1 1-1h4c.6 0 1 .4 1 1z\\\" fill=\\\"currentColor\\\"\\/><g opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" fill=\\\"currentColor\\\"><path d=\\\"M25 12.2L20.9 16c-1.8 1.7-5 1.5-6.5-.4-.8-1-2.4-1.1-3.4-.2L8.6 18 7 16.8l2.5-2.5c1.8-1.8 5.1-1.7 6.6.3.8 1 2.4 1.1 3.3.2l4.1-3.8 1.5 1.2z\\\"\\/><path d=\\\"M17.5 8c-.8 0-1.5.7-1.5 1.5s.7 1.5 1.5 1.5 1.5-.7 1.5-1.5S18.3 8 17.5 8zM14 9.5C14 7.6 15.6 6 17.5 6S21 7.6 21 9.5 19.4 13 17.5 13 14 11.4 14 9.5z\\\"\\/><\\/g><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1608978735471,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"22px 0px 16px 0px\",\"xl\":\"22px 0px 16px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"images\\/2020\\/12\\/25\\/brick-wall-dark.png\",\"height\":69,\"width\":110},\"background_parallax\":0,\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(52, 52, 52, 0.8)\",\"color2\":\"rgba(255, 255, 255, 0.7)\",\"deg\":\"90\",\"type\":\"linear\",\"pos\":\"25\",\"pos2\":\"100\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"instFormId\":1608978735471,\"background_color\":\"\",\"overlay\":\"rgba(0, 0, 0, 0.88)\",\"fit_columns\":{\"xxl\":false,\"xl\":false,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false}},\"layout\":\"12,4,4,4\",\"columns\":[{\"id\":1608978735470,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608990238562,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Our qualified team\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"47\",\"xl\":\"47\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px   30px\",\"xl\":\"0px   30px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-right\",\"title_text_shadow\":{\"ho\":0,\"vo\":\"2\",\"blur\":\"0\",\"spread\":0,\"color\":\"#5c5c5c\",\"inset\":false},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"700\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608990238562,\"title_font_family\":\"Reenie Beanie\",\"global_text_color\":\"#ff9700\",\"title_font_style\":{\"weight\":400},\"global_animation\":\"bounceInDown\"},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608986696516,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608988467567,\"name\":\"person\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/umiesniony-kulturysta-robi-push-up-ze-sztanga-w-pozycji-deski-z-nagim-cialem_95891-3479.jpg\",\"height\":417,\"width\":626},\"image_border_radius\":\"8\",\"person_style_preset\":\"default\",\"content_overlay_type\":\"color\",\"content_overlay_color\":\"rgba(0, 0, 0, 0.66)\",\"content_overlay_gradient\":{\"color\":\"rgba(0, 0, 0, 0.8)\",\"color2\":\"rgba(255, 0, 4, 0.7)\",\"deg\":\"130\",\"type\":\"linear\"},\"name_desig_bg\":\"#fff\",\"name_desig_padding\":\"15px 0px 15px 15px\",\"person_content_bg\":\"#fff\",\"person_content_padding\":{\"xxl\":\"15px 15px 15px 15px\",\"xl\":\"15px 15px 15px 15px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"name\":\"Tomas MEKI\",\"name_fontsize\":{\"xxl\":\"26\",\"xl\":\"26\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"name_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"name_letterspace\":\"2px\",\"designation\":\"Personal trainer\",\"designation_fontsize\":\"\",\"designation_lineheight\":{\"xxl\":\"5\",\"xl\":\"5\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"designation_letterspace\":\"0px\",\"designation_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"email\":\"personall-trener@email.com\",\"introtext\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.\",\"introtext_color\":\"\",\"introtext_fontsize\":{\"xxl\":\"13\",\"xl\":\"13\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"introtext_lineheight\":\"\",\"facebook\":\"#\",\"twitter\":\"#\",\"social_icon_color\":\"#ff9300\",\"social_icon_hover_color\":\"#000000\",\"social_icon_fontsize\":\"\",\"social_icon_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"social_position\":\"before\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":\"\",\"global_border_radius\":{\"xxl\":\"1\",\"xl\":\"1\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"5px 5px 5px 5px\",\"xl\":\"5px 5px 5px 5px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":\"11\",\"spread\":\"3\",\"color\":\"#414141\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"200\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":1,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"1\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608988467567,\"global_background_color\":\"#ffffff\",\"name_color\":\"#ff9200\",\"name_font_family\":\"Abel\",\"designation_color\":\"#000000\",\"designation_font_family\":\"Abel\",\"introtext_font_family\":\"Abel\",\"global_animation\":\"zoomIn\",\"global_border_color\":\"#ffffff\",\"global_boder_style\":\"solid\",\"youtube\":\"#\",\"linkedin\":\"#\"},\"title\":\"Person\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M19.418 14.634h-6.836C9.504 14.634 7 16.772 7 19.4v9.648c0 .526.5.953 1.116.953h15.768C24.5 30 25 29.573 25 29.047v-9.648c0-2.627-2.504-4.765-5.582-4.765z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M16 2c-3.23 0-5.86 2.57-5.86 5.73 0 2.144 1.21 4.016 2.997 4.998a5.925 5.925 0 002.863.733c1.04 0 2.016-.267 2.863-.733 1.787-.982 2.996-2.854 2.996-4.998C21.86 4.57 19.231 2 16 2z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608986696517,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608986697519,\"name\":\"person\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/26\\/woman-lifting-dumbbell_1208-271.jpg\",\"height\":417,\"width\":626},\"image_border_radius\":\"8\",\"person_style_preset\":\"default\",\"content_overlay_type\":\"color\",\"content_overlay_color\":\"rgba(0, 0, 0, 0.66)\",\"content_overlay_gradient\":{\"color\":\"rgba(0, 0, 0, 0.8)\",\"color2\":\"rgba(255, 0, 4, 0.7)\",\"deg\":\"130\",\"type\":\"linear\"},\"name_desig_bg\":\"#fff\",\"name_desig_padding\":\"15px 0px 15px 15px\",\"person_content_bg\":\"#fff\",\"person_content_padding\":{\"xxl\":\"15px 15px 15px 15px\",\"xl\":\"15px 15px 15px 15px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"name\":\"Aneta LIS\",\"name_fontsize\":{\"xxl\":\"26\",\"xl\":\"26\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"name_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"name_letterspace\":\"2px\",\"designation\":\"Personal trainer\",\"designation_fontsize\":\"\",\"designation_lineheight\":{\"xxl\":\"5\",\"xl\":\"5\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"designation_letterspace\":\"0px\",\"designation_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"email\":\"personall-trener@email.com\",\"introtext\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.\",\"introtext_color\":\"\",\"introtext_fontsize\":{\"xxl\":\"13\",\"xl\":\"13\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"introtext_lineheight\":\"\",\"facebook\":\"#\",\"twitter\":\"#\",\"social_icon_color\":\"#ff9300\",\"social_icon_hover_color\":\"#000000\",\"social_icon_fontsize\":\"\",\"social_icon_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"social_position\":\"before\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":\"\",\"global_border_radius\":{\"xxl\":\"1\",\"xl\":\"1\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_margin\":{\"xxl\":\"-30px 0px 30px 0px\",\"xl\":\"-30px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"5px 5px 5px 5px\",\"xl\":\"5px 5px 5px 5px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":\"11\",\"spread\":\"3\",\"color\":\"#414141\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"400\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":1,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"1\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608986697519,\"global_background_color\":\"#ffffff\",\"name_color\":\"#ff9200\",\"name_font_family\":\"Abel\",\"designation_color\":\"#000000\",\"designation_font_family\":\"Abel\",\"introtext_font_family\":\"Abel\",\"global_animation\":\"zoomIn\",\"global_border_color\":\"#ffffff\",\"global_boder_style\":\"solid\",\"youtube\":\"#\",\"linkedin\":\"#\"},\"title\":\"Person\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M19.418 14.634h-6.836C9.504 14.634 7 16.772 7 19.4v9.648c0 .526.5.953 1.116.953h15.768C24.5 30 25 29.573 25 29.047v-9.648c0-2.627-2.504-4.765-5.582-4.765z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M16 2c-3.23 0-5.86 2.57-5.86 5.73 0 2.144 1.21 4.016 2.997 4.998a5.925 5.925 0 002.863.733c1.04 0 2.016-.267 2.863-.733 1.787-.982 2.996-2.854 2.996-4.998C21.86 4.57 19.231 2 16 2z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608986696518,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608986697522,\"name\":\"person\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/26\\/bodybuilder-strong-man-pumping-up-abs-muscles_174475-1396.jpg\",\"height\":417,\"width\":626},\"image_border_radius\":\"8\",\"person_style_preset\":\"default\",\"content_overlay_type\":\"color\",\"content_overlay_color\":\"rgba(0, 0, 0, 0.66)\",\"content_overlay_gradient\":{\"color\":\"rgba(0, 0, 0, 0.8)\",\"color2\":\"rgba(255, 0, 4, 0.7)\",\"deg\":\"130\",\"type\":\"linear\"},\"name_desig_bg\":\"#fff\",\"name_desig_padding\":\"15px 0px 15px 15px\",\"person_content_bg\":\"#fff\",\"person_content_padding\":{\"xxl\":\"15px 15px 15px 15px\",\"xl\":\"15px 15px 15px 15px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"name\":\"Paul SIX\",\"name_fontsize\":{\"xxl\":\"26\",\"xl\":\"26\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"name_lineheight\":\"\",\"name_letterspace\":\"2px\",\"designation\":\"Personal trainer\",\"designation_fontsize\":\"\",\"designation_lineheight\":{\"xxl\":\"5\",\"xl\":\"5\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"designation_letterspace\":\"0px\",\"designation_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"email\":\"personall-trener@email.com\",\"introtext\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.\",\"introtext_color\":\"\",\"introtext_fontsize\":{\"xxl\":\"13\",\"xl\":\"13\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"introtext_lineheight\":\"\",\"facebook\":\"#\",\"twitter\":\"#\",\"social_icon_color\":\"#ff9300\",\"social_icon_hover_color\":\"#000000\",\"social_icon_fontsize\":\"\",\"social_icon_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"social_position\":\"before\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":\"\",\"global_border_radius\":{\"xxl\":\"1\",\"xl\":\"1\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"5px 5px 5px 5px\",\"xl\":\"5px 5px 5px 5px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":\"11\",\"spread\":\"3\",\"color\":\"#414141\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"600\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"xxl\":\"5\",\"xl\":\"5\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":1,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"1\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608986697522,\"global_background_color\":\"#ffffff\",\"name_color\":\"#ff9200\",\"name_font_family\":\"Abel\",\"designation_color\":\"#000000\",\"designation_font_family\":\"Abel\",\"introtext_font_family\":\"Abel\",\"global_animation\":\"zoomIn\",\"global_border_color\":\"#ffffff\",\"global_boder_style\":\"solid\",\"youtube\":\"#\",\"linkedin\":\"#\"},\"title\":\"Person\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M19.418 14.634h-6.836C9.504 14.634 7 16.772 7 19.4v9.648c0 .526.5.953 1.116.953h15.768C24.5 30 25 29.573 25 29.047v-9.648c0-2.627-2.504-4.765-5.582-4.765z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M16 2c-3.23 0-5.86 2.57-5.86 5.73 0 2.144 1.21 4.016 2.997 4.998a5.925 5.925 0 002.863.733c1.04 0 2.016-.267 2.863-.733 1.787-.982 2.996-2.854 2.996-4.998C21.86 4.57 19.231 2 16 2z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1609047999123,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"xxl\":\"28px 0px 36px 0px\",\"xl\":\"28px 0px 36px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"images\\/2020\\/12\\/25\\/black-orchid.png\",\"height\":300,\"width\":300},\"background_parallax\":0,\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1609047999123,\"row_border\":0,\"background_color\":\"#000000\",\"row_boxshadow\":{\"ho\":\"0\",\"vo\":\"0\",\"blur\":\"0\",\"spread\":\"1\",\"color\":\"rgba(72, 72, 72, 0.61)\",\"inset\":false},\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},\"layout\":\"12\",\"columns\":[{\"id\":1609047999142,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1609047999143,\"name\":\"testimonial_carousel\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"carousel_options\":\"elements\",\"testimonial_carousel_layout\":\"testi_layout2\",\"show_quote_icon\":0,\"carousel_margin\":15,\"carousel_autoplay\":1,\"carousel_speed\":1500,\"carousel_interval\":4500,\"sp_testimonial_carousel_item\":[{\"client_name\":\"Tomas MEKI\",\"client_desgination\":\"\",\"client_message\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer \",\"show_rating\":0,\"client_rating\":4.5,\"testimonial_carousel_img\":{\"src\":\"images\\/2020\\/12\\/26\\/bodybuilder-strong-man-pumping-up-abs-muscles_174475-1396.jpg\",\"height\":417,\"width\":626}},{\"client_name\":\"Aneta LIS\",\"client_desgination\":\"\",\"client_message\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin\",\"show_rating\":0,\"client_rating\":4.5,\"testimonial_carousel_img\":{\"src\":\"images\\/2020\\/12\\/26\\/woman-lifting-dumbbell_1208-271.jpg\",\"height\":417,\"width\":626}},{\"client_name\":\"Gregor\",\"client_desgination\":\"\",\"client_message\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin\",\"show_rating\":0,\"client_rating\":4.5,\"testimonial_carousel_img\":{\"src\":\"images\\/2020\\/12\\/25\\/umiesniony-kulturysta-robi-push-up-ze-sztanga-w-pozycji-deski-z-nagim-cialem_95891-3479.jpg\",\"height\":417,\"width\":626}},{\"client_name\":\"Anton\",\"client_desgination\":\"\",\"client_message\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer \",\"show_rating\":0,\"client_rating\":4.5,\"testimonial_carousel_img\":{\"src\":\"images\\/2020\\/12\\/25\\/zakonczenie-portret-mlody-afroamerican-bokser-pokazuje-jego-piesci_171337-8290.jpg\",\"height\":417,\"width\":626}}],\"content_alignment\":\"sppb-text-center\",\"avatar_layout\":\"avatar_layout1\",\"avatar_height\":60,\"avatar_width\":60,\"avatar_border_radius\":100,\"avatar_gap\":15,\"quote_icon_color\":\"#dbdbdb\",\"quote_icon_size\":50,\"quote_icon_gap\":20,\"rating_color\":\"#ff5e00\",\"rating_size\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"rating_gap\":{\"xxl\":\"5\",\"xl\":\"5\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_style\":\"name_style\",\"name_text_color\":\"#ffaa00\",\"name_fontsize\":{\"xxl\":\"38\",\"xl\":\"38\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"name_lineheight\":\"\",\"name_letterspace\":\"0px\",\"name_margin\":{\"xxl\":\"10px 0px 0px 0px\",\"xl\":\"10px 0px 0px 0px\",\"lg\":\"0px 0px 0px 0px\",\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"designation_text_color\":\"#888d92\",\"designation_fontsize\":{\"xxl\":\"30\",\"xl\":\"30\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"designation_lineheight\":\"17\",\"designation_letterspace\":\"0px\",\"message_background\":\"#f8f8f8\",\"message_text_color\":\"#929292\",\"message_fontsize\":{\"xxl\":\"36\",\"xl\":\"36\",\"lg\":\"30\",\"md\":\"30\",\"sm\":\"30\",\"xs\":\"30\"},\"message_lineheight\":{\"xxl\":\"53\",\"xl\":\"53\",\"lg\":\"50\",\"md\":\"50\",\"sm\":\"40\",\"xs\":\"40\"},\"message_letterspace\":\"0px\",\"message_margin_bottom\":{\"xxl\":\"60\",\"xl\":\"60\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"message_padding\":{\"xxl\":\"30px 30px 30px 30px\",\"xl\":\"30px 30px 30px 30px\",\"lg\":\"25px 25px 25px 25px\",\"md\":\"25px 25px 25px 25px\",\"sm\":\"15px 15px 15px 15px\",\"xs\":\"15px 15px 15px 15px\"},\"carousel_navigation\":\"bullet_controller\",\"carousel_bullet\":1,\"bullet_style\":\"normal_bullet\",\"bullet_height\":\"3\",\"bullet_width\":\"19\",\"bullet_background\":\"#d8d8d8\",\"bullet_border_width\":0,\"bullet_border_color\":\"\",\"bullet_active_background\":\"#696969\",\"carousel_arrow\":1,\"arrow_icon\":\"long_arrow\",\"arrow_style\":\"hover_arrow\",\"arrow_height\":50,\"arrow_width\":52,\"arrow_background\":\"rgba(179, 180, 191, 0)\",\"arrow_color\":\"rgba(255, 255, 255, 0.29)\",\"arrow_font_size\":24,\"arrow_border_width\":0,\"arrow_border_color\":\"#181818\",\"arrow_border_radius\":\"0\",\"arrow_hover_background\":\"\",\"arrow_hover_color\":\"#9c9c9c\",\"arrow_hover_border_color\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1609047999143,\"content_padding\":{\"xxl\":\"0px 150px 0px 150px\",\"xl\":\"0px 150px 0px 150px\",\"lg\":\"0px 80px 0px 80px\",\"md\":\"0px 80px 0px 80px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"carousel_item_number\":{\"xxl\":\"1\",\"xl\":\"1\",\"lg\":\"1\",\"md\":\"1\",\"sm\":\"1\",\"xs\":\"1\"},\"message_font_family\":\"Abel\",\"message_font_style\":{\"weight\":700},\"name_font_style\":{\"uppercase\":true},\"name_font_family\":\"Abel\",\"bullet_position_verti\":{\"xxl\":\"-8\",\"xl\":\"-8\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bullet_position_hori\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"}},\"title\":\"Testimonial Carousel\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><circle opacity=\\\".5\\\" cx=\\\"10.5\\\" cy=\\\"30.5\\\" r=\\\"1.5\\\" fill=\\\"currentColor\\\"\\/><circle opacity=\\\".5\\\" cx=\\\"22.5\\\" cy=\\\"30.5\\\" r=\\\"1.5\\\" fill=\\\"currentColor\\\"\\/><circle cx=\\\"16.5\\\" cy=\\\"30.5\\\" r=\\\"1.5\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M22 2H10v21h12V2zM10 0a2 2 0 00-2 2v21a2 2 0 002 2h12a2 2 0 002-2V2a2 2 0 00-2-2H10z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M6 4a1 1 0 00-1-1H1a1 1 0 000 2h3v15H1a1 1 0 100 2h4a1 1 0 001-1V4zm20 17a1 1 0 001 1h4a1 1 0 100-2h-3V5h3a1 1 0 100-2h-4a.996.996 0 00-1 1v17z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M13 7.496c0 .381.309.69.69.69h.779v.297c0 .527-.364.975-.858 1.097-.148.037-.273.157-.273.31v.848c0 .152.124.277.275.26a2.538 2.538 0 002.256-2.515V5.69a.69.69 0 00-.69-.69h-1.49a.69.69 0 00-.689.69v1.806zM16.6 7.496c0 .381.309.69.69.69h.779v.297c0 .527-.364.975-.858 1.097-.148.037-.273.157-.273.31v.848c0 .152.124.277.275.26a2.538 2.538 0 002.256-2.515V5.69a.69.69 0 00-.69-.69h-1.49a.69.69 0 00-.689.69v1.806z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M12 15a1 1 0 011-1h6a1 1 0 110 2h-6a1 1 0 01-1-1zM13 19a1 1 0 011-1h4a1 1 0 110 2h-4a1 1 0 01-1-1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1608994273139,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"14px 0px 30px 0px\",\"xl\":\"14px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"background_parallax\":0,\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(166, 0, 0, 0.8)\",\"color2\":\"rgba(0, 0, 0, 0.84)\",\"deg\":\"45\",\"type\":\"radial\",\"radialPos\":\"top left\",\"pos2\":\"62\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"turning-slope\",\"shape_color\":\"rgba(255, 255, 255, 0.03)\",\"shape_width\":{\"xxl\":\"600\",\"xl\":\"600\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"600\",\"xl\":\"600\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":1,\"shape_invert\":0,\"shape_to_front\":0,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"instFormId\":1608994273139,\"overlay\":\"\",\"background_color\":\"#252525\",\"fit_columns\":{\"xxl\":false,\"xl\":false,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false}},\"layout\":\"12,4,8\",\"columns\":[{\"id\":1608994273138,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608998705430,\"name\":\"animated_heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"heading_style\":\"highlighted\",\"heading_before_part\":\"Contact\",\"highlighted_text\":\"details\",\"highlighted_shape\":\"zigzag-underline\",\"shape_color\":\"#ffffff\",\"shape_width\":\"2\",\"shape_radius\":0,\"animated_text\":\"awesome\\nnice\\ncool\",\"text_animation_name\":\"clip\",\"heading_after_part\":\"\",\"heading_selector\":\"h1\",\"style_options\":\"heading\",\"heading_fontsize\":{\"xxl\":\"50\",\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"heading_lineheight\":\"\",\"heading_letterspace\":\"\",\"heading_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"heading_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"animated_text_fontsize\":\"\",\"animated_text_letterspace\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":\"0\",\"spread\":\"0\",\"color\":\"\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608998705430,\"heading_font_family\":\"Reenie Beanie\",\"animated_text_font_style\":{\"weight\":100},\"heading_font_style\":{\"weight\":100},\"heading_color\":\"#ffffff\"},\"title\":\"Animated Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M18.2 12c-2.1.3-4.1 2.1-5.5 4.4C10.8 11.3 7.1 7 2.5 7c-.4 0-.8 0-1.1.1-.8.1-1.4.8-1.4 1.6 0 1 .9 1.7 1.9 1.6.2-.1.4-.1.6-.1 4.3 0 8.2 7 8.2 13.1 0 .8.6 1.5 1.3 1.6 1.1.2 2-.6 2-1.6 0-3.1 2.3-7.3 4.3-8-.1-.6-.2-1.2-.2-1.8 0-.6 0-1 .1-1.5z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M26.3 19.3c3.2 0 5.7-2.6 5.7-5.7s-2.6-5.7-5.7-5.7-5.7 2.6-5.7 5.7 2.5 5.7 5.7 5.7z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608994273140,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608999404234,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt. Aenean quis massa uada mi elementum elementum.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608999404234,\"text_font_family\":\"Abel\",\"global_text_color\":\"#f7f7f7\"},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1608999835047,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"PHONE : 123-456-189\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"20\",\"xl\":\"20\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608999835047,\"title_icon\":\"fas fa-phone-alt\",\"title_font_family\":\"Abel\",\"title_icon_color\":\"#b1b1b1\",\"global_text_color\":\"#A7A7A7\"},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1608998239400,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"EMAIL : office@email.com\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"20\",\"xl\":\"20\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608998239400,\"title_icon\":\"fas fa-paper-plane\",\"title_font_family\":\"Abel\",\"title_icon_color\":\"#b1b1b1\",\"global_text_color\":\"#A7A7A7\"},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1608999520474,\"name\":\"social_share\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"show_socials\":[\"facebook\",\"twitter\",\"linkedin\",\"pinterest\"],\"show_social_names\":\"0\",\"icon_align\":\"center\",\"social_style\":\"custom\",\"social_use_border\":1,\"social_border_width\":1,\"social_border_radius\":\"4px\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608999520474,\"social_border_color\":\"#fffafa\",\"social_border_hover_color\":\"#ff9600\",\"icon_hover_color\":\"#ff8500\",\"background_hover_color\":\"rgba(255, 255, 255, 0.39)\",\"icon_color\":\"#ffffff\"},\"title\":\"Social Share\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M24.5 2a3.5 3.5 0 100 7 3.5 3.5 0 000-7zM19 5.5a5.5 5.5 0 1111 0 5.5 5.5 0 01-11 0zM6.5 12.5a3.5 3.5 0 100 7 3.5 3.5 0 000-7zM1 16a5.5 5.5 0 1111 0 5.5 5.5 0 01-11 0zM24.5 23a3.5 3.5 0 100 7 3.5 3.5 0 000-7zM19 26.5a5.5 5.5 0 1111 0 5.5 5.5 0 01-11 0z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M9.521 17.762a1 1 0 011.367-.361l10.246 5.97a1 1 0 01-1.007 1.728l-10.245-5.97a1 1 0 01-.361-1.367zM21.479 7.261a1 1 0 01-.36 1.368l-10.23 5.97a1 1 0 01-1.008-1.728l10.23-5.97a1 1 0 011.368.36z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608994273141,\"class_name\":\"col-md-8\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608994969286,\"name\":\"openstreetmap\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"height\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"map_style\":\"Stamen.TonerLite\",\"multi_location_items\":[{\"title\":\"Location Item Title\",\"location_item\":\"50.09714, 20.05415\",\"location_popup_text\":\"Krak\\u00f3w os Na Stoku\",\"custom_icon\":{\"src\":\"\"}}],\"zoom\":\"17\",\"mousescroll\":0,\"dragging\":1,\"zoomcontrol\":0,\"attribution\":1,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":\"\",\"global_border_radius\":{\"xxl\":\"1\",\"xl\":\"1\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"10px 10px 10px 10px\",\"xl\":\"10px 10px 10px 10px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":\"0\",\"vo\":0,\"blur\":\"8\",\"spread\":\"0\",\"color\":\"rgba(11, 11, 11, 0.77)\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608994969286,\"global_border_color\":\"rgba(0, 0, 0, 0.56)\",\"global_boder_style\":\"solid\",\"global_animation\":\"fadeIn\"},\"title\":\"Open Street Map\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M12.3 12.125c-.232-2.793.475-5.33 2.202-7.567.327-.43.691-.823 1.077-1.195.503-.485 1.042-.935 1.582-1.387l.087-.072c-.297-.172-.61-.285-.919-.397-.378-.137-.749-.271-1.074-.507h-.348c-.756.3-1.546.493-2.336.686-.432.105-.864.21-1.29.334-.98.28-1.97.53-2.96.78-.404.102-.809.205-1.213.31l-.024.005c-.175.044-.332.084-.532.017a649.995 649.995 0 00-4.106-1.341l-.089-.029-2.097-.68c-.026 0-.039-.026-.053-.052A.339.339 0 00.19 1H.074l.021.063.087.258.008.027.07.208.07.213.538 1.613c.422 1.262.847 2.525 1.28 3.783.128.36.14.684.012 1.054-.313.91-.617 1.82-.921 2.73-.304.91-.608 1.819-.921 2.729-.116.37-.116.695 0 1.066.231.73.457 1.46.684 2.193.363 1.174.726 2.349 1.112 3.52.127.405.116.764 0 1.17a776.683 776.683 0 00-2.005 6.918c-.011.035-.027.07-.044.105-.048.106-.098.214-.037.335.209.44 1.298.719 1.68.406a8.165 8.165 0 00.319-.278c.233-.213.455-.436.678-.66l.139-.14c1.17-1.176 2.344-2.349 3.517-3.522 1.173-1.174 2.347-2.347 3.517-3.523.417-.417.88-.73 1.483-.556.533.15.939-.012 1.321-.337.117-.095.23-.195.344-.295.203-.18.407-.36.63-.516.278-.197.278-.37.127-.66-.355-.693-.704-1.395-1.053-2.099-.3-.603-.6-1.207-.905-1.806-.174-.348-.29-.73.023-1.009.569-.512.515-1.132.459-1.787a18.783 18.783 0 01-.007-.078zm-1.963.549a5.334 5.334 0 00-.01-.138l-.012-.153-.008-.09v-.003c-.258-3.108.487-6.005 2.316-8.558-.268.067-.525.133-.788.21h-.005c-1.01.29-2.048.552-3.049.805-.398.1-.79.2-1.172.298l-.008.002-.007.002-.03.008c-.174.048-.857.234-1.643-.027-.896-.297-1.79-.59-2.686-.88.265.787.532 1.572.802 2.356.264.75.299 1.538.015 2.364-.31.9-.612 1.802-.916 2.713l-.002.004c-.29.87-.584 1.748-.886 2.627.232.734.454 1.452.674 2.162.358 1.157.71 2.296 1.092 3.455l.004.013.004.013c.261.832.222 1.595.015 2.32l-.003.009-.003.01c-.292.987-.581 1.976-.868 2.965l1.782-1.783.002-.002a2033.18 2033.18 0 003.513-3.519l.004-.003c.465-.466 1.498-1.366 2.968-1.167l-.51-1.025c-.305-.614-.605-1.218-.88-1.756l-.003-.007-.003-.006c-.116-.231-.339-.707-.378-1.292a2.555 2.555 0 01.679-1.927zM30.494 23.273v-.002l-.158-1.294c-.067-.548-.134-1.1-.205-1.662l-.002-.02-.064-.51-.06.026a.914.914 0 00-.172.09c-.536.384-1.083.723-1.643 1.012-2.067 1.069-4.3 1.468-6.735 1.085a.859.859 0 00-.823.324c-.394.487-.834.464-1.333.209-.564-.286-1.128-.561-1.692-.837l-.845-.415-.029-.014c-1.432-.704-1.439-.707-2.475.536l-.046.055c-.287.34-.572.678-.44 1.173.197.742-.14 1.252-.626 1.738A2414.87 2414.87 0 007.9 29.97l-.607.606-.008.007v.001l-.095.095-.29.29c-.037.036-.084.071-.133.108-.137.102-.28.21-.203.355.085.17.237.118.394.065.078-.027.158-.054.232-.054a.342.342 0 00.156-.028l.057-.023c.036-.015.073-.03.111-.041l1.006-.287 1.362-.386.198-.056c1.34-.38 2.68-.76 4.016-1.149a1.838 1.838 0 011.17.035c1.088.394 2.18.784 3.272 1.174.806.287 1.612.575 2.418.866.302.115.58.127.881.011l1.602-.618c1.274-.493 2.55-.986 3.833-1.468.313-.116.51-.301.649-.602.483-1.03.971-2.055 1.458-3.078.33-.694.66-1.386.987-2.08l.025-.049c.063-.12.123-.238.103-.39zM13.024 27.7l.513-.15.01-.002a3.836 3.836 0 012.385.072l.008.003.007.002c1.088.394 2.169.78 3.256 1.168.73.26 1.462.522 2.2.788l1.306-.504c1.173-.454 2.357-.911 3.543-1.359.439-.931.883-1.866 1.325-2.795l.878-1.848-.008-.066a12.588 12.588 0 01-6.726 1.042 2.802 2.802 0 01-1.508.642c-.773.08-1.417-.174-1.82-.38-.551-.28-1.091-.543-1.646-.814-.285-.14-.573-.28-.87-.427l-.027-.013-.027-.013-.015.018a3.38 3.38 0 01-.254 1.716c-.27.63-.688 1.094-.994 1.4l-.008.008-1.528 1.512z\\\" fill=\\\"currentColor\\\"\\/><circle opacity=\\\".5\\\" cx=\\\"24.5\\\" cy=\\\"10.5\\\" r=\\\"7.5\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"66.666666666667%\",\"xl\":\"66.666666666667%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":\"6BIjpkNQ3oB-ZRnhj6zkj\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"6XDRfhQUq3xorcRrGUSso\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608838531297,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"YogaFit For Pregnant\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"9:30 - 10:30\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/trening-w-domu_144627-44356.jpg\",\"height\":417,\"width\":626},\"image_width\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_border_radius\":\"0\",\"image_gutter\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_tag\":1,\"image_tag_text\":\"HOT\",\"image_tag_bg\":\"#ff0000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":\"0\",\"image_tag_left_margin\":\"0\",\"text\":\"Angela Kirk\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608838531296,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"YogaFit For Beginners\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"13:30 - 15:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/piekna-dziewczyna-jest-zaangazowana-w-studio-jogi_1157-29221.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"YOGA\",\"image_tag_bg\":\"#000000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Angela Kirk\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608838531298,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Cross Fit\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"16:00 - 17:30\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/mlody-sprawnosc-fizyczna-mezczyzna-w-studiu_7502-5004.jpg\",\"height\":416,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"CROSSFIT\",\"image_tag_bg\":\"#000000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"David Second\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608892539151,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Boxing\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"18:00 - 20:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/zakonczenie-portret-mlody-afroamerican-bokser-pokazuje-jego-piesci_171337-8290.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"BOXING\",\"image_tag_bg\":\"#ff0000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Mike Tyson\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608892539152,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Body Building\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"22:00 - 24:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/umiesniony-kulturysta-robi-push-up-ze-sztanga-w-pozycji-deski-z-nagim-cialem_95891-3479.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"BODY BUILDING\",\"image_tag_bg\":\"#ff9700\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Kevin Nomak\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":1608838531206,\"columnId\":1608838531205},\"parent_addon\":\"hCJyQ7C4wq21E1Lax_Cx0\"},{\"id\":\"6Un3B3QLeM-FrgX1YVUQ3\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"-Z1XqkbHxtjqTKmwRuHca\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608895394241,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"YogaFit For Pregnant\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"9:30 - 10:30\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/trening-w-domu_144627-44356.jpg\",\"height\":417,\"width\":626},\"image_width\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_border_radius\":\"0\",\"image_gutter\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_tag\":1,\"image_tag_text\":\"HOT\",\"image_tag_bg\":\"#ff0000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":\"0\",\"image_tag_left_margin\":\"0\",\"text\":\"Angela Kirk\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895394242,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"YogaFit For Beginners\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"13:30 - 15:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/piekna-dziewczyna-jest-zaangazowana-w-studio-jogi_1157-29221.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"YOGA\",\"image_tag_bg\":\"#000000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Angela Kirk\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895394244,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Boxing\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"18:00 - 20:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/zakonczenie-portret-mlody-afroamerican-bokser-pokazuje-jego-piesci_171337-8290.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"BOXING\",\"image_tag_bg\":\"#ff0000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Mike Tyson\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895394245,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Body Building\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"22:00 - 24:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/umiesniony-kulturysta-robi-push-up-ze-sztanga-w-pozycji-deski-z-nagim-cialem_95891-3479.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"BODY BUILDING\",\"image_tag_bg\":\"#ff9700\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Kevin Nomak\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":\"6BIjpkNQ3oB-ZRnhj6zkj\",\"columnId\":1608838531205},\"parent_addon\":\"hCJyQ7C4wq21E1Lax_Cx0\"},{\"id\":\"ojBwNGZTZaTwbnxKJFZ41\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"io7GdC9uOax6YHQZAGk2r\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608895395978,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"YogaFit For Pregnant\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"9:30 - 10:30\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/trening-w-domu_144627-44356.jpg\",\"height\":417,\"width\":626},\"image_width\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_border_radius\":\"0\",\"image_gutter\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_tag\":1,\"image_tag_text\":\"HOT\",\"image_tag_bg\":\"#ff0000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":\"0\",\"image_tag_left_margin\":\"0\",\"text\":\"Angela Kirk\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895395979,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"YogaFit For Beginners\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"13:30 - 15:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/piekna-dziewczyna-jest-zaangazowana-w-studio-jogi_1157-29221.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"YOGA\",\"image_tag_bg\":\"#000000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Angela Kirk\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895395980,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Cross Fit\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"16:00 - 17:30\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/mlody-sprawnosc-fizyczna-mezczyzna-w-studiu_7502-5004.jpg\",\"height\":416,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"CROSSFIT\",\"image_tag_bg\":\"#000000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"David Second\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895395981,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Boxing\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"18:00 - 20:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/zakonczenie-portret-mlody-afroamerican-bokser-pokazuje-jego-piesci_171337-8290.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"BOXING\",\"image_tag_bg\":\"#ff0000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Mike Tyson\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895395982,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Body Building\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"22:00 - 24:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/umiesniony-kulturysta-robi-push-up-ze-sztanga-w-pozycji-deski-z-nagim-cialem_95891-3479.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"BODY BUILDING\",\"image_tag_bg\":\"#ff9700\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Kevin Nomak\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":\"6Un3B3QLeM-FrgX1YVUQ3\",\"columnId\":1608838531205},\"parent_addon\":\"hCJyQ7C4wq21E1Lax_Cx0\"},{\"id\":\"aqyGOTFiAENekdP9kVNCY\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"_xrsBr8jo3ioFPnfJoMrA\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608895397992,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"YogaFit For Pregnant\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"9:30 - 10:30\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/trening-w-domu_144627-44356.jpg\",\"height\":417,\"width\":626},\"image_width\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_border_radius\":\"0\",\"image_gutter\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_tag\":1,\"image_tag_text\":\"HOT\",\"image_tag_bg\":\"#ff0000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":\"0\",\"image_tag_left_margin\":\"0\",\"text\":\"Angela Kirk\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895397993,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"YogaFit For Beginners\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"13:30 - 15:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/piekna-dziewczyna-jest-zaangazowana-w-studio-jogi_1157-29221.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"YOGA\",\"image_tag_bg\":\"#000000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Angela Kirk\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895397994,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Cross Fit\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"16:00 - 17:30\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/mlody-sprawnosc-fizyczna-mezczyzna-w-studiu_7502-5004.jpg\",\"height\":416,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"CROSSFIT\",\"image_tag_bg\":\"#000000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"David Second\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895397995,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Boxing\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"18:00 - 20:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/zakonczenie-portret-mlody-afroamerican-bokser-pokazuje-jego-piesci_171337-8290.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"BOXING\",\"image_tag_bg\":\"#ff0000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Mike Tyson\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895397996,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Body Building\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"22:00 - 24:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/umiesniony-kulturysta-robi-push-up-ze-sztanga-w-pozycji-deski-z-nagim-cialem_95891-3479.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"BODY BUILDING\",\"image_tag_bg\":\"#ff9700\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Kevin Nomak\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":\"ojBwNGZTZaTwbnxKJFZ41\",\"columnId\":1608838531205},\"parent_addon\":\"hCJyQ7C4wq21E1Lax_Cx0\"},{\"id\":\"4TltdptXx1oz0AlzDyWhe\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"cLVNRahOYkpaF_uF3-EFS\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608895399418,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"YogaFit For Pregnant\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"9:30 - 10:30\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/trening-w-domu_144627-44356.jpg\",\"height\":417,\"width\":626},\"image_width\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_border_radius\":\"0\",\"image_gutter\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_tag\":1,\"image_tag_text\":\"HOT\",\"image_tag_bg\":\"#ff0000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":\"0\",\"image_tag_left_margin\":\"0\",\"text\":\"Angela Kirk\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895399419,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"YogaFit For Beginners\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"13:30 - 15:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/piekna-dziewczyna-jest-zaangazowana-w-studio-jogi_1157-29221.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"YOGA\",\"image_tag_bg\":\"#000000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Angela Kirk\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895399420,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Cross Fit\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"16:00 - 17:30\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/mlody-sprawnosc-fizyczna-mezczyzna-w-studiu_7502-5004.jpg\",\"height\":416,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"CROSSFIT\",\"image_tag_bg\":\"#000000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"David Second\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895399421,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Boxing\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"18:00 - 20:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/zakonczenie-portret-mlody-afroamerican-bokser-pokazuje-jego-piesci_171337-8290.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"BOXING\",\"image_tag_bg\":\"#ff0000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Mike Tyson\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895399422,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Body Building\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"22:00 - 24:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/umiesniony-kulturysta-robi-push-up-ze-sztanga-w-pozycji-deski-z-nagim-cialem_95891-3479.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"BODY BUILDING\",\"image_tag_bg\":\"#ff9700\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Kevin Nomak\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":\"aqyGOTFiAENekdP9kVNCY\",\"columnId\":1608838531205},\"parent_addon\":\"hCJyQ7C4wq21E1Lax_Cx0\"},{\"id\":\"GBoD0SIWklQOderT_Xt_d\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"rXgm_M8xFbXR5BNY5bes6\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608895400819,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"YogaFit For Pregnant\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"9:30 - 10:30\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/trening-w-domu_144627-44356.jpg\",\"height\":417,\"width\":626},\"image_width\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_border_radius\":\"0\",\"image_gutter\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_tag\":1,\"image_tag_text\":\"HOT\",\"image_tag_bg\":\"#ff0000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":\"0\",\"image_tag_left_margin\":\"0\",\"text\":\"Angela Kirk\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895400820,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"YogaFit For Beginners\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"13:30 - 15:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/piekna-dziewczyna-jest-zaangazowana-w-studio-jogi_1157-29221.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"YOGA\",\"image_tag_bg\":\"#000000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Angela Kirk\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895400821,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Cross Fit\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"16:00 - 17:30\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/mlody-sprawnosc-fizyczna-mezczyzna-w-studiu_7502-5004.jpg\",\"height\":416,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"CROSSFIT\",\"image_tag_bg\":\"#000000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"David Second\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895400822,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Boxing\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"18:00 - 20:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/zakonczenie-portret-mlody-afroamerican-bokser-pokazuje-jego-piesci_171337-8290.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"BOXING\",\"image_tag_bg\":\"#ff0000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Mike Tyson\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895400823,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Body Building\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"22:00 - 24:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/umiesniony-kulturysta-robi-push-up-ze-sztanga-w-pozycji-deski-z-nagim-cialem_95891-3479.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"BODY BUILDING\",\"image_tag_bg\":\"#ff9700\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Kevin Nomak\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":\"4TltdptXx1oz0AlzDyWhe\",\"columnId\":1608838531205},\"parent_addon\":\"hCJyQ7C4wq21E1Lax_Cx0\"},{\"id\":\"Avq4oiTJL67CN18dHdrw4\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"QnCYvpjy-3xVRYq3dvOIu\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608895470556,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"YogaFit For Pregnant\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"9:30 - 10:30\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/trening-w-domu_144627-44356.jpg\",\"height\":417,\"width\":626},\"image_width\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_border_radius\":\"0\",\"image_gutter\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_tag\":1,\"image_tag_text\":\"HOT\",\"image_tag_bg\":\"#ff0000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":\"0\",\"image_tag_left_margin\":\"0\",\"text\":\"Angela Kirk\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895470557,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"YogaFit For Beginners\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"13:30 - 15:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/piekna-dziewczyna-jest-zaangazowana-w-studio-jogi_1157-29221.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"YOGA\",\"image_tag_bg\":\"#000000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Angela Kirk\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895470558,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Cross Fit\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"16:00 - 17:30\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/24\\/mlody-sprawnosc-fizyczna-mezczyzna-w-studiu_7502-5004.jpg\",\"height\":416,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"CROSSFIT\",\"image_tag_bg\":\"#000000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"David Second\",\"text_fontsize\":\"\",\"text_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"price_font_family\":\"Abel\",\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895470559,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Boxing\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"18:00 - 20:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/zakonczenie-portret-mlody-afroamerican-bokser-pokazuje-jego-piesci_171337-8290.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"BOXING\",\"image_tag_bg\":\"#ff0000\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Mike Tyson\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true},{\"id\":1608895470560,\"name\":\"pricelist\",\"settings\":{\"admin_label\":\"\",\"title\":\"Body Building\",\"title_fontsize\":\"\",\"title_letterspace\":\"0\",\"price_position\":\"right-to-title\",\"price\":\"22:00 - 24:00\",\"zero_position\":\"\",\"price_color\":\"#ff5f00\",\"price_fontsize\":\"\",\"price_fontweight\":700,\"price_top_gap\":\"\",\"price_bottom_gap\":\"\",\"discount_price\":\"\",\"discount_price_color\":\"\",\"discount_price_position\":\"\",\"add_line\":1,\"line_style\":\"solid\",\"line_size\":\"1\",\"line_color\":\"rgba(129, 129, 129, 0.2)\",\"line_position\":\"center\",\"line_top_gap\":0,\"line_bottom_gap\":0,\"add_number_or_image\":1,\"number_or_image_left\":\"image\",\"number_text\":\"1\",\"number_bg_color\":\"\",\"number_color\":\"\",\"number_fontsize\":\"\",\"number_fontweight\":\"\",\"number_fontstyle\":\"normal\",\"number_top_padding\":\"\",\"number_bottom_padding\":\"\",\"image\":{\"src\":\"images\\/2020\\/12\\/25\\/umiesniony-kulturysta-robi-push-up-ze-sztanga-w-pozycji-deski-z-nagim-cialem_95891-3479.jpg\",\"height\":417,\"width\":626},\"image_width\":15,\"image_border_radius\":\"\",\"image_gutter\":15,\"image_tag\":1,\"image_tag_text\":\"BODY BUILDING\",\"image_tag_bg\":\"#ff9700\",\"image_tag_radius\":\"\",\"image_tag_top_margin\":0,\"image_tag_left_margin\":0,\"text\":\"Kevin Nomak\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"content_position\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"Abel\",\"text_font_family\":\"Abel\",\"title_text_color\":\"#ffffff\"},\"title\":\"Price List\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.379 6.36c-.53-.304-1.094-.535-1.652-.775a3.674 3.674 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.168 5.168 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 2.251.17 3.118.09 4.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.723-.387.177-.798.22-1.219.165A5.302 5.302 0 01.898 9.79c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.075.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 5c0 .552-.428 1-.956 1H10.956C10.428 6 10 5.552 10 5s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 10a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M5.379 24.36c-.53-.304-1.094-.535-1.652-.775a3.675 3.675 0 01-.907-.527c-.538-.445-.435-1.168.196-1.454.178-.08.365-.107.555-.119a4.088 4.088 0 012.087.428c.33.165.438.113.55-.242.117-.376.214-.758.323-1.137.073-.254-.017-.422-.248-.529a5.166 5.166 0 00-1.317-.408c-.597-.095-.597-.098-.6-.72-.003-.876-.003-.876-.851-.876-.123 0-.246-.003-.368 0-.396.012-.463.084-.475.498-.005.185 0 .37-.002.558-.003.549-.006.54-.514.731C.93 20.251.17 21.118.09 22.506c-.073 1.23.547 2.059 1.52 2.663.6.373 1.264.593 1.9.885.249.113.486.243.692.422.611.524.5 1.394-.226 1.724-.387.176-.798.22-1.219.164a5.302 5.302 0 01-1.858-.575c-.343-.185-.444-.136-.561.249-.1.332-.19.668-.279 1.003-.12.451-.075.558.34.769.53.266 1.097.402 1.674.497.453.076.466.096.472.582.003.22.003.442.006.662.002.277.13.44.407.445.312.006.628.006.94-.003.257-.006.388-.15.388-.42 0-.3.014-.604.003-.904-.014-.307.114-.463.399-.544a3.144 3.144 0 001.643-1.093c1.194-1.503.74-3.704-.951-4.672z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M32 23c0 .552-.428 1-.956 1H10.956c-.528 0-.956-.448-.956-1s.428-1 .957-1h20.087c.528 0 .956.448.956 1zM21 28a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":\"GBoD0SIWklQOderT_Xt_d\",\"columnId\":1608838531205},\"parent_addon\":\"hCJyQ7C4wq21E1Lax_Cx0\"},{\"id\":1608960040551,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":1,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"2px 0px 50px 0px\",\"xl\":\"2px 0px 50px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":1,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"instFormId\":1608960040551,\"columns_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"fit_columns\":{\"xxl\":false,\"xl\":false,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false}},\"layout\":\"6,6,12,2,2,2,2,2,2\",\"visibility\":true,\"columns\":[{\"id\":1608960040552,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1608960040552},\"addons\":[{\"id\":1608961287087,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"BODY MASS INDEX\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608961287087,\"title_font_family\":\"Abel\",\"global_text_color\":\"#ff5400\",\"global_animation\":\"fadeInLeft\"},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608960040555,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608964882901,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images\\/2020\\/12\\/26\\/bmi1.png\",\"height\":105,\"width\":312},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-right\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608964882901,\"image_height\":{\"xxl\":\"50\",\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_width\":{\"xxl\":\"130\",\"xl\":\"130\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_animation\":\"fadeIn\"},\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1608964767045,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"14\",\"xl\":\"14\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-center\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608964767045},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608960040556,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608963171242,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images\\/2020\\/12\\/26\\/bmi6.png\",\"height\":473,\"width\":989},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"1000\",\"global_animationdelay\":\"700\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608963171242,\"global_animation\":\"fadeIn\"},\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608960040557,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608961629544,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"<b>40><\\/b>\\nobesity third  degree\\n\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"4px 4px 4px 4px\",\"xl\":\"4px 4px 4px 4px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":\"\",\"global_border_radius\":{\"xxl\":\"4\",\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xxl\":\"0px 4px  \",\"xl\":\"0px 4px  \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"6px 6px 6px 6px\",\"xl\":\"6px 6px 6px 6px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"100\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608961629544,\"global_text_color\":\"#ef3c25\",\"global_boder_style\":\"solid\",\"title_font_family\":\"Abel\",\"global_border_color\":\"#ef3c25\",\"global_animation\":\"fadeInDown\"},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"16.666666666667%\",\"xl\":\"16.666666666667%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608960040558,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608963145889,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"<b>35-40<\\/b>\\nobesity second  degree\\n\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"4px 4px 4px 4px\",\"xl\":\"4px 4px 4px 4px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":\"\",\"global_border_radius\":{\"xxl\":\"4\",\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xxl\":\"0px 4px  \",\"xl\":\"0px 4px  \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"6px 6px 6px 6px\",\"xl\":\"6px 6px 6px 6px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"200\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608963145889,\"global_text_color\":\"#e34d28\",\"global_boder_style\":\"solid\",\"title_font_family\":\"Abel\",\"global_link_hover_color\":\"#e34d28\",\"global_animation\":\"fadeInDown\"},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"16.666666666667%\",\"xl\":\"16.666666666667%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608960040559,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608963145894,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"<b>30-35<\\/b>\\nobesity first  degree\\n\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"4px 4px 4px 4px\",\"xl\":\"4px 4px 4px 4px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":\"\",\"global_border_radius\":{\"xxl\":\"4\",\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xxl\":\"0px 4px  \",\"xl\":\"0px 4px  \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"6px 6px 6px 6px\",\"xl\":\"6px 6px 6px 6px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"300\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608963145894,\"global_text_color\":\"#ca6e2f\",\"global_boder_style\":\"solid\",\"title_font_family\":\"Abel\",\"global_border_color\":\"#ca6e2f\",\"global_animation\":\"fadeInDown\"},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"16.666666666667%\",\"xl\":\"16.666666666667%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608960040560,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608963145899,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"<b>25-30<\\/b>\\nweight over<br><br>\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":\"\",\"global_border_radius\":{\"xxl\":\"4\",\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xxl\":\"0px 4px  \",\"xl\":\"0px 4px  \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"6px 6px 6px 6px\",\"xl\":\"6px 6px 6px 6px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"400\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608963145899,\"global_text_color\":\"#8dc03f\",\"global_boder_style\":\"solid\",\"title_font_family\":\"Abel\",\"global_border_color\":\"#8dc03f\",\"global_animation\":\"fadeInDown\"},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"16.666666666667%\",\"xl\":\"16.666666666667%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608960040561,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608963145904,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"<b>18,5-24<\\/b>\\nnorm<br><br><br>\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":\"\",\"global_border_radius\":{\"xxl\":\"4\",\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xxl\":\"0px 4px  \",\"xl\":\"0px 4px  \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"6px 6px 6px 6px\",\"xl\":\"6px 6px 6px 6px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"500\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608963145904,\"global_text_color\":\"#81d142\",\"global_boder_style\":\"solid\",\"title_font_family\":\"Abel\",\"global_border_color\":\"#81d142\",\"global_animation\":\"fadeInDown\"},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"16.666666666667%\",\"xl\":\"16.666666666667%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608960040562,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1608963145909,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"<b>16-18,5<\\/b>\\nbody weight deficit\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":\"\",\"global_border_radius\":{\"xxl\":\"4\",\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xxl\":\"0px 4px  \",\"xl\":\"0px 4px  \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"6px 6px 6px 6px\",\"xl\":\"6px 6px 6px 6px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"600\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608963145909,\"global_text_color\":\"#35ba6d\",\"global_boder_style\":\"solid\",\"title_font_family\":\"Abel\",\"global_border_color\":\"#35ba6d\",\"global_animation\":\"fadeInDown\"},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"16.666666666667%\",\"xl\":\"16.666666666667%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":1608960040525,\"columnId\":1608960040532}}]', 'com_sppagebuilder', 'page', '0', '0', '1', '0', '1', '0', '2018-02-22 07:16:05', '580', '2023-03-12 17:06:44', '580', '0', '0000-00-00 00:00:00', '[]', '', '', '', '*', '4204', '');/**ABDB**/
