<?php
/**--------------------------------------
 * @package     ruxin_news - Ruxin News
 * @copyright   Copyright (C) 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later.
 * ---------------------------------------**/
defined('_JEXEC') or die;

$show_link_image = $params->get('show_link_thumbnail', 1);
$link_thumbnail_float = $params->get('link_image_align', 'none');

$link_thumbnail_width = $params->get('link_thumbnail_width', '600');
$link_thumbnail_height = $params->get('link_thumbnail_height', '200');

$link_column = $params->get('link_column', 1);
$link_items = array_slice($list, $lead_count + $intro_count, $link_count);
$link_text_type = $params->get('link_text_type', 'news_on_image');

if (!$show_link_image) $link_text_type = 'news_normal';

$link_title_size = $params->get('link_title_size', 18);

$show_link_title = $params->get('show_link_title', 1);
$show_link_intro = $params->get('show_link_introtext', 0);
$link_title_limit = $params->get('link_title_limit', 120);
$link_introtext_limit = $params->get('link_introtext_limit', 120);

$show_link_date = $params->get('show_link_date', 'LC1');
$show_link_hits = $params->get('show_link_hits', 0);
$show_link_cat = $params->get('show_link_cat', 0);
$link_cat_top = $params->get('link_cat_top', 0);

$show_link_author = $params->get('show_link_author', 0);

$link_title_weight = $params->get('link_title_weight', 400);
$link_image_count = 0;
$link_width = $params->get('link_width', '50%');

$link_text_center = $params->get('link_text_center', 0);

$link_date_icon = ($link_text_type == "news_on_image") ? JURI::root()."modules/mod_ruxin_news/includes/images/date.png" : JURI::root()."modules/mod_ruxin_news/includes/images/date-dark.png";
$link_hits_icon = ($link_text_type == "news_on_image") ? JURI::root()."modules/mod_ruxin_news/includes/images/hits.png" : JURI::root()."modules/mod_ruxin_news/includes/images/hits-dark.png";
$link_author_icon = ($link_text_type == "news_on_image") ? JURI::root()."modules/mod_ruxin_news/includes/images/author.png" : JURI::root()."modules/mod_ruxin_news/includes/images/author-dark.png";

$link_show_read_more = $params->get('link_show_read_more', 0);
$link_read_more_text = $params->get('link_read_more_text', 'Read More...');
$link_read_more_color = $params->get('link_read_more_color', '#c7c7c7');
$link_read_more_font_size = $params->get('link_read_more_font_size', '13px');

// Extra Fields
$link_show_field = $params->get('link_show_field', 0);
$link_field_position = $params->get('link_field_position', "before_title");
$link_field_number = $params->get('link_field_number', 0);
$link_field_character_limit = $params->get('link_field_character_limit', 80);
$link_field_text = $params->get('link_field_text', "");
?>

<div class="news-link">

    <?php foreach (array_chunk($link_items, $link_column) as $posts_row) { ?>

        <div class="news-row">

            <?php foreach ($posts_row as $key => $item){ ?>

                <div class="ruxin-news-col-<?php echo $link_column; ?>">

                    <div class="news-item">
                        <?php if ($show_link_image) { ?>
                        <a href="<?php echo $item->link; ?>" class="title" itemprop="url">
                            <?php if ($link_text_type == "news_on_image") { ?>
                                <div class="<?php echo $image_hover_effect; ?>">
                                    <img class="link_news_image" src="<?php echo $images[$link_image_count + $lead_count + $intro_count]['link_thumb']; ?>" alt="<?php echo $item->title; ?>" style="height: <?php echo $link_thumbnail_height;?>px;"/>
									<!-- Show Category -->
									<?php if ($show_link_cat && $link_cat_top) { ?>
										<div class = "link_category_top link_catid_<?php echo $item->catid; ?>">
											<a href="<?php echo $item->categoryLink; ?>">
												<?php echo $item->category_title; ?>
											</a>
										</div>
									<?php } ?>
								</div>
                            <?php } else if ($link_thumbnail_float == "left") { ?>
                                <img class="link_news_image float_left" src="<?php echo $images[$link_image_count + $lead_count + $intro_count]['link_thumb']; ?>" alt="<?php echo $item->title; ?>" style="width: <?php echo $link_thumbnail_width;?>px; height: <?php echo $link_thumbnail_height;?>px;"/>
									<!-- Show Category -->
									<?php if ($show_link_cat && $link_cat_top) { ?>
										<div class = "link_category_top link_catid_<?php echo $item->catid; ?>">
											<a href="<?php echo $item->categoryLink; ?>">
												<?php echo $item->category_title; ?>
											</a>
										</div>
									<?php } ?>
							<?php } else if ($link_thumbnail_float == "right") { ?>
                                <img class="link_news_image float_right" src="<?php echo $images[$link_image_count + $lead_count + $intro_count]['link_thumb']; ?>" alt="<?php echo $item->title; ?>" style="width: <?php echo $link_thumbnail_width;?>px; height: <?php echo $link_thumbnail_height;?>px;"/>
									<!-- Show Category -->
									<?php if ($show_link_cat && $link_cat_top) { ?>
										<div class = "link_category_top link_catid_<?php echo $item->catid; ?>">
											<a href="<?php echo $item->categoryLink; ?>">
												<?php echo $item->category_title; ?>
											</a>
										</div>
									<?php } ?>
							<?php } else { ?>
							    <img class="link_news_image float_none" src="<?php echo $images[$link_image_count + $lead_count + $intro_count]['link_thumb']; ?>" alt="<?php echo $item->title; ?>" style="width: <?php echo $link_thumbnail_width;?>px; height: <?php echo $link_thumbnail_height;?>px;"/>
							<?php } ?>
							
                        </a>
							<!-- Show Category -->
							<?php if ($show_link_cat && $link_cat_top) { ?>
								<div class = "link_category_top link_catid_<?php echo $item->catid; ?>">
									<a href="<?php echo $item->categoryLink; ?>">
										<?php echo $item->category_title; ?>
									</a>
								</div>
							<?php } ?>
                        <?php } ?>

                        <?php if ($show_link_title || $show_link_intro || $show_link_date || $show_link_hits || $show_link_cat || $show_link_author) { ?>
                            
							<?php if ($link_text_type == "news_on_image") { ?>
								<a href="<?php echo $item->link; ?>"><div class="link_on_image"></div></a>
							<?php } ?>
							
							<div class="item_description <?php echo $link_text_type; ?>">

                                <!-- Show Category -->
                                <?php if ($show_link_cat && !$link_cat_top) { ?>
                                    <div class = "link_category">
                                        <a href="<?php echo $item->categoryLink; ?>" class="link_catid_<?php echo $item->catid; ?>">
                                            <?php echo $item->category_title; ?>
                                        </a>
                                    </div>
                                <?php } ?>

								<!-- Show Extra Field Before Title -->
								<?php if ($link_show_field && $link_field_position == "before_title") {
									if ($source == "category") { //Joomla Field
										$fields = FieldsHelper::getFields('com_content.article', $item, true);
										if (!empty($fields[$link_field_number]->value)) {
											echo "<span class='link_news_field'>{$link_field_text} {$functions->trimText($fields[$link_field_number]->value, $link_field_character_limit, "char", "...")}</span>"; 
										}
									} else { //K2 Field
										$item_extra_fields = json_decode($item->extra_fields);
										if (!empty($item_extra_fields[$link_field_number]->value)) {
											echo "<span class='link_news_field'>{$link_field_text} {$functions->trimText($item_extra_fields[$link_field_number]->value, $link_field_character_limit, "char", "...")}</span>"; 
										}
									} 
								} ?>
								
                                <!-- Show Title -->
                                <a href="<?php echo $item->link; ?>" class="link_title" itemprop="url" style="font-size: <?php echo $link_title_size; ?>px; font-weight: <?php echo $link_title_weight; ?>;"><?php echo $functions->trimText($item->title, $link_title_limit, "char", "..."); ?></a>

								<!-- Show Extra Field After Title -->
								<?php if ($link_show_field && $link_field_position == "after_title") {
									if ($source == "category") { //Joomla Field
										$fields = FieldsHelper::getFields('com_content.article', $item, true);
										if (!empty($fields[$link_field_number]->value)) {
											echo "<span class='link_news_field'>{$link_field_text} {$functions->trimText($fields[$link_field_number]->value, $link_field_character_limit, "char", "...")}</span>"; 
										}
									} else { //K2 Field
										$item_extra_fields = json_decode($item->extra_fields);
										if (!empty($item_extra_fields[$link_field_number]->value)) {
											echo "<span class='link_news_field'>{$link_field_text} {$functions->trimText($item_extra_fields[$link_field_number]->value, $link_field_character_limit, "char", "...")}</span>"; 
										}
									} 
								} ?>
								
                                <!-- Show Text -->
                                <?php if ($show_link_intro) { ?>
                                    <p class="link_introtext"><?php echo $functions->trimText($item->introtext, $link_introtext_limit, "char", "..."); ?></p>
                                <?php } ?>

								<!-- Show Read More -->
								<?php if ($link_show_read_more) { ?>
									<a href="<?php echo $item->link; ?>" class="link_read_more" style="color: <?php echo $link_read_more_color; ?>; font-size: <?php echo $link_read_more_font_size; ?>;"><?php echo $link_read_more_text; ?></a>
								<?php } ?>

								<div class="link_date_hits_author">
									<!-- Show Date -->
									<?php if ($show_link_date) { ?>
										<div class="link_date">
											<img class="link_date_icon" src="<?php echo $link_date_icon; ?>"/>
											<time datetime="<?php echo $item->publish_up ?>" itemprop="datePublished">
												<?php echo JHtml::_('date', $item->publish_up, JText::_("DATE_FORMAT_$show_link_date")); ?>
											</time>
										</div>
									<?php } ?>

									<!-- Show Hits -->
									<?php if ($show_link_hits) { ?>
										<div class="link_hits">
											<img class="link_hits_icon" src="<?php echo $link_hits_icon; ?>"/>
											<meta itemprop="interactionCount" content="UserPageVisits:<?php echo $item->hits; ?>"><?php echo $item->hits; ?>
										</div>
									<?php } ?>

									<!-- Show Joomla Author -->
									<?php if ($show_link_author && $source == "category") { ?>
										<?php if (isset($item->author) && $item->author !== "" || isset($item->created_by_alias) && $item->created_by_alias !== "") { ?>
											<div class="link_auhor" itemprop="author" itemtype="http://schema.org/Person">
												<img class="link_author_icon" src="<?php echo $link_author_icon; ?>"/>
												<?php if (isset($item->author)) echo $item->author; else echo $item->created_by_alias; ?>
											</div>
										<?php }
									} ?>
									
									<!-- Show K2 Author -->
									<?php if ($show_link_author && $source == "k2_category") { ?>
										<?php if (isset($item->created_by)) { ?>
											<div class="link_auhor" itemprop="author" itemtype="http://schema.org/Person">
												<img class="link_author_icon" src="<?php echo $link_author_icon; ?>"/>
												<?php $author = JFactory::getUser($item->created_by);
												echo $author->name; ?>
											</div>
										<?php }
									} ?>
								</div>

                            </div>
                        <?php } ?>

                    </div>
                </div>

            <?php $link_image_count += 1;
            } ?>

        </div>
    <?php } ?>

</div>

<style>
    #ruxin_news_<?php echo $module->id ?> .news-link {
        width: <?php echo $link_width; ?>;
    }
	
	<?php if ($link_text_center) { ?>
	#ruxin_news_<?php echo $module->id ?> .news-link .item_description, #ruxin_news_<?php echo $module->id ?> .news-link .link_category {
		text-align: center;
		margin: 0 auto;
	}
	<?php } ?>
</style>

